/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ReadResolutionCalculator {
    static final Logger LOGGER = Logging.getLogger(ReadResolutionCalculator.class);
    private ReferencedEnvelope requestedBBox;
    private Rectangle requestedRasterArea;
    private AffineTransform requestedGridToWorld;
    private double[] fullResolution;
    private boolean accurateResolution;
    private MathTransform destinationToSourceTransform;

    public ReadResolutionCalculator(GridGeometry2D requestedGridGeometry, CoordinateReferenceSystem nativeCrs, double[] fullResolution) throws FactoryException {
        CoordinateReferenceSystem requestedCRS;
        Utilities.ensureNonNull((String)"gridGeometry", (Object)requestedGridGeometry);
        this.requestedBBox = new ReferencedEnvelope(requestedGridGeometry.getEnvelope2D());
        this.requestedRasterArea = requestedGridGeometry.getGridRange2D().getBounds();
        this.requestedGridToWorld = (AffineTransform)requestedGridGeometry.getGridToCRS2D();
        this.fullResolution = fullResolution;
        if (fullResolution == null) {
            this.fullResolution = this.computeClassicResolution();
        }
        if (!CRS.equalsIgnoreMetadata(nativeCrs, requestedCRS = requestedGridGeometry.getCoordinateReferenceSystem())) {
            this.destinationToSourceTransform = CRS.findMathTransform(requestedCRS, nativeCrs);
        }
    }

    public double[] computeRequestedResolution(ReferencedEnvelope readBounds) {
        try {
            if (this.requestedGridToWorld instanceof LinearTransform) {
                if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                    if (this.accurateResolution) {
                        return this.computeAccurateResolution(readBounds);
                    }
                    return this.computeClassicResolution();
                }
                return new double[]{XAffineTransform.getScaleX0(this.requestedGridToWorld), XAffineTransform.getScaleY0(this.requestedGridToWorld)};
            }
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)this.requestedGridToWorld.toString()));
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, the reader will pick the native one");
            return this.fullResolution;
        }
    }

    private double[] computeClassicResolution() {
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(new GridEnvelope2D(this.requestedRasterArea), this.requestedBBox);
        AffineTransform tempTransform = geMapper.createAffineTransform();
        return new double[]{XAffineTransform.getScaleX0(tempTransform), XAffineTransform.getScaleY0(tempTransform)};
    }

    private double[] computeAccurateResolution(ReferencedEnvelope readBBox) throws TransformException, NoninvertibleTransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata(readBBox.getCoordinateReferenceSystem(), this.requestedBBox.getCoordinateReferenceSystem())) {
            readBBox = readBBox.transform(this.requestedBBox.getCoordinateReferenceSystem(), true);
        }
        double resX = XAffineTransform.getScaleX0(this.requestedGridToWorld);
        double resY = XAffineTransform.getScaleY0(this.requestedGridToWorld);
        GeneralEnvelope cropBboxTarget = CRS.transform(readBBox, this.requestedBBox.getCoordinateReferenceSystem());
        int NPOINTS = 36;
        double[] points = new double[72];
        for (int i = 0; i < 3; ++i) {
            double x = i == 0 ? cropBboxTarget.getMinimum(0) + resX / 2.0 : (i == 1 ? cropBboxTarget.getMedian(0) : cropBboxTarget.getMaximum(0) - resX / 2.0);
            for (int j = 0; j < 3; ++j) {
                double y = j == 0 ? cropBboxTarget.getMinimum(1) + resY / 2.0 : (j == 1 ? cropBboxTarget.getMedian(1) : cropBboxTarget.getMaximum(1) - resY / 2.0);
                int k = (i * 3 + j) * 8;
                points[k] = x - resX / 2.0;
                points[k + 1] = y;
                points[k + 2] = x + resX / 2.0;
                points[k + 3] = y;
                points[k + 4] = x;
                points[k + 5] = y - resY / 2.0;
                points[k + 6] = x;
                points[k + 7] = y + resY / 2.0;
            }
        }
        this.destinationToSourceTransform.transform(points, 0, points, 0, 36);
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < points.length && minDistance > 0.0; i += 4) {
            double dx = points[i + 2] - points[i];
            double dy = points[i + 3] - points[i + 1];
            double d = Math.sqrt(dx * dx + dy * dy);
            if (!(d < minDistance)) continue;
            minDistance = d;
        }
        double minDistanceX = Math.max(minDistance, this.fullResolution[0]);
        double minDistanceY = Math.max(minDistance, this.fullResolution[1]);
        return new double[]{minDistanceX, minDistanceY};
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }
}

