/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbDecoder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class HANAWkbDecoder
extends PostgisWkbDecoder {
    private int currentTypeCode;

    HANAWkbDecoder() {
    }

    @Override
    protected <P extends Position> CoordinateReferenceSystem<P> readCrs(ByteBuffer byteBuffer, int typeCode, CoordinateReferenceSystem<P> crs) {
        boolean hasZ;
        boolean hasM = (this.currentTypeCode & 0x40000000) == 0x40000000;
        boolean bl = hasZ = (this.currentTypeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if ((this.currentTypeCode & 0xFFFF) > 3000) {
            hasM = true;
            hasZ = true;
        } else if ((this.currentTypeCode & 0xFFFF) > 2000) {
            hasM = true;
        } else if ((this.currentTypeCode & 0xFFFF) > 1000) {
            hasZ = true;
        }
        int modifiedTypeCode = this.currentTypeCode;
        if (hasM) {
            modifiedTypeCode |= 0x40000000;
        }
        if (hasZ) {
            modifiedTypeCode |= Integer.MIN_VALUE;
        }
        return super.readCrs(byteBuffer, modifiedTypeCode, crs);
    }

    @Override
    protected int readTypeCode(ByteBuffer byteBuffer) {
        this.currentTypeCode = super.readTypeCode(byteBuffer);
        return (this.currentTypeCode & 0xFFFF) % 100;
    }
}

