/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geotools.util.Converters;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.SimpleBinding;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;

public class XSDateTimeBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DATETIME;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Class getType() {
        return Timestamp.class;
    }

    @Override
    public Timestamp parse(InstanceComponent instance, Object value) throws Exception {
        Calendar calendar = DatatypeConverterImpl.getInstance().parseDateTime((String)value, true);
        Timestamp dateTime = new Timestamp(calendar.getTimeInMillis());
        return dateTime;
    }

    @Override
    public String encode(Object object, String value) {
        Date timestamp = Converters.convert(object, Date.class);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        return DatatypeConverterImpl.getInstance().printDateTime(cal);
    }
}

