/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.utilities;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;

public class ImageUtilities {
    private static final boolean mediaLibAvailable;

    public static boolean isMediaLibAvailable() {
        return mediaLibAvailable;
    }

    public static boolean isCLibAvailable() {
        return PackageUtil.isCodecLibAvailable();
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        if (Double.class.equals((Object)type)) {
            if (amount < 0) {
                do {
                    value = ImageUtilities.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = ImageUtilities.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        if (Float.class.equals((Object)type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = ImageUtilities.next(vf, false);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = ImageUtilities.next(vf, true);
                } while (--amount != 0);
            }
            return vf;
        }
        if (ImageUtilities.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException("Unsupported DataType: " + type);
    }

    @Deprecated
    public static boolean isInteger(Class<?> type) {
        return type != null && Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static void fillBackground(WritableRaster raster, Rectangle rect, double[] backgroundValues) {
        block44: {
            PixelAccessor accessor;
            block43: {
                rect = rect.intersection(raster.getBounds());
                SampleModel sm = raster.getSampleModel();
                accessor = new PixelAccessor(sm, null);
                if (!ImageUtilities.isBinary(sm)) break block43;
                byte value = (byte)((int)backgroundValues[0] & 1);
                if (value == 0) {
                    return;
                }
                int rectX = rect.x;
                int rectY = rect.y;
                int rectWidth = rect.width;
                int rectHeight = rect.height;
                int dx = rectX - raster.getSampleModelTranslateX();
                int dy = rectY - raster.getSampleModelTranslateY();
                DataBuffer dataBuffer = raster.getDataBuffer();
                MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                int lineStride = mpp.getScanlineStride();
                int eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                int bitOffset = mpp.getBitOffset(dx);
                switch (sm.getDataType()) {
                    case 0: {
                        byte[] data = ((DataBufferByte)dataBuffer).getData();
                        int bits = bitOffset & 7;
                        int otherBits = bits == 0 ? 0 : 8 - bits;
                        byte mask = (byte)(255 >> bits);
                        int lineLength = (rectWidth - otherBits) / 8;
                        int bits1 = rectWidth - otherBits & 7;
                        byte mask1 = (byte)(255 << 8 - bits1);
                        if (lineLength == 0) {
                            mask = (byte)(mask & mask1);
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = (byte)(data[n] | mask);
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start;
                                data[n] = (byte)(data[n] | mask1);
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                    case 1: {
                        short[] data = ((DataBufferUShort)dataBuffer).getData();
                        int bits = bitOffset & 0xF;
                        int otherBits = bits == 0 ? 0 : 16 - bits;
                        short mask = (short)(65535 >> bits);
                        int lineLength = (rectWidth - otherBits) / 16;
                        int bits1 = rectWidth - otherBits & 0xF;
                        short mask1 = (short)(65535 << 16 - bits1);
                        if (lineLength == 0) {
                            mask = (short)(mask & mask1);
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = (short)(data[n] | mask);
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start++;
                                data[n] = (short)(data[n] | mask1);
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                    case 3: {
                        int[] data = ((DataBufferInt)dataBuffer).getData();
                        int bits = bitOffset & 0x1F;
                        int otherBits = bits == 0 ? 0 : 32 - bits;
                        int mask = -1 >> bits;
                        int lineLength = (rectWidth - otherBits) / 32;
                        int bits1 = rectWidth - otherBits & 0x1F;
                        int mask1 = -1 << 32 - bits1;
                        if (lineLength == 0) {
                            mask &= mask1;
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = data[n] | mask;
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start++;
                                data[n] = data[n] | mask1;
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                }
                break block44;
            }
            int srcSampleType = accessor.sampleType == -1 ? 0 : accessor.sampleType;
            UnpackedImageData uid = accessor.getPixels((Raster)raster, rect, srcSampleType, false);
            rect = uid.rect;
            int lineStride = uid.lineStride;
            int pixelStride = uid.pixelStride;
            switch (uid.type) {
                case 0: {
                    byte[][] bdata = uid.getByteData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        byte value = (byte)backgroundValues[b];
                        byte[] bd = bdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                bd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sdata = uid.getShortData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        short value = (short)backgroundValues[b];
                        short[] sd = sdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                sd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    int[][] idata = uid.getIntData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        int value = (int)backgroundValues[b];
                        int[] id = idata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                id[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    float[][] fdata = uid.getFloatData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        float value = (float)backgroundValues[b];
                        float[] fd = fdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                fd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    double[][] ddata = uid.getDoubleData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        double value = backgroundValues[b];
                        double[] dd = ddata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                dd[po] = value;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static boolean isBinary(SampleModel sm) {
        return sm instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sm).getPixelBitStride() == 1 && sm.getNumBands() == 1;
    }

    public static TiledImage createConstantImage(int width, int height, Number value) {
        return ImageUtilities.createConstantImage(width, height, new Number[]{value});
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, Number value) {
        return ImageUtilities.createConstantImage(minx, miny, width, height, new Number[]{value});
    }

    public static TiledImage createConstantImage(int width, int height, Number[] values) {
        return ImageUtilities.createConstantImage(0, 0, width, height, values);
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, Number[] values) {
        Dimension tileSize = JAI.getDefaultTileSize();
        return ImageUtilities.createConstantImage(minx, miny, width, height, tileSize.width, tileSize.height, values);
    }

    public static TiledImage createConstantImage(int minx, int miny, int width, int height, int tileWidth, int tileHeight, Number[] values) {
        int i;
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("values array must contain at least 1 value");
        }
        int numBands = values.length;
        double[] doubleValues = null;
        float[] floatValues = null;
        int[] intValues = null;
        Object[] typedValues = null;
        int dataType = 32;
        if (values[0] instanceof Double) {
            doubleValues = new double[values.length];
            dataType = 5;
            for (i = 0; i < numBands; ++i) {
                doubleValues[i] = (Double)values[i];
            }
            typedValues = doubleValues;
        } else if (values[0] instanceof Float) {
            floatValues = new float[values.length];
            dataType = 4;
            for (i = 0; i < numBands; ++i) {
                floatValues[i] = ((Float)values[i]).floatValue();
            }
            typedValues = floatValues;
        } else if (values[0] instanceof Integer) {
            intValues = new int[values.length];
            dataType = 3;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = (Integer)values[i];
            }
            typedValues = intValues;
        } else if (values[0] instanceof Short) {
            intValues = new int[values.length];
            dataType = 2;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = ((Short)values[i]).shortValue();
            }
            typedValues = intValues;
        } else if (values[0] instanceof Byte) {
            intValues = new int[values.length];
            dataType = 0;
            for (i = 0; i < numBands; ++i) {
                intValues[i] = ((Byte)values[i]).byteValue();
            }
            typedValues = intValues;
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + values[0].getClass().getName());
        }
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileWidth, (int)tileHeight, (int)numBands);
        ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
        TiledImage tImg = new TiledImage(minx, miny, width, height, 0, 0, sm, cm);
        WritableRaster tile0 = null;
        int tileW = 0;
        int tileH = 0;
        for (int tileY = tImg.getMinTileY(); tileY <= tImg.getMaxTileY(); ++tileY) {
            for (int tileX = tImg.getMinTileX(); tileX <= tImg.getMaxTileX(); ++tileX) {
                WritableRaster raster = tImg.getWritableTile(tileX, tileY);
                WritableRaster child = raster.createWritableTranslatedChild(0, 0);
                if (tile0 == null) {
                    tile0 = child;
                    tileW = tile0.getWidth();
                    tileH = tile0.getHeight();
                    ImageUtilities.fillRaster(tile0, tileW, tileH, dataType, typedValues);
                } else {
                    child.setDataElements(0, 0, tile0);
                }
                tImg.releaseWritableTile(tileX, tileY);
            }
        }
        return tImg;
    }

    public static TiledImage createImageFromArray(Number[] array, int width, int height) {
        if (array == null) {
            throw new IllegalArgumentException("array must be non-null");
        }
        if (array.length == 0 || array.length != width * height) {
            throw new IllegalArgumentException("The array must be non-empty and have length width x height");
        }
        Number val = array[0];
        TiledImage img = ImageUtilities.createConstantImage(width, height, val);
        if (array[0] instanceof Double) {
            ImageUtilities.fillImageAsDouble(img, array, width, height);
        } else if (array[0] instanceof Float) {
            ImageUtilities.fillImageAsFloat(img, array, width, height);
        } else if (array[0] instanceof Integer) {
            ImageUtilities.fillImageAsInt(img, array, width, height);
        } else if (array[0] instanceof Short) {
            ImageUtilities.fillImageAsShort(img, array, width, height);
        } else if (array[0] instanceof Byte) {
            ImageUtilities.fillImageAsByte(img, array, width, height);
        } else {
            throw new UnsupportedOperationException("Unsupported data type: " + array[0].getClass().getName());
        }
        return img;
    }

    private static void fillImageAsDouble(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].doubleValue());
            }
        }
    }

    private static void fillImageAsFloat(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].floatValue());
            }
        }
    }

    private static void fillImageAsInt(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, array[k++].intValue());
            }
        }
    }

    private static void fillImageAsShort(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, (int)array[k++].shortValue());
            }
        }
    }

    private static void fillImageAsByte(TiledImage img, Number[] array, int width, int height) {
        int k = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.setSample(x, y, 0, (int)array[k++].byteValue());
            }
        }
    }

    public static Color[] createRampColours(int numColours) {
        return ImageUtilities.createRampColours(numColours, 0.8f, 0.8f);
    }

    public static Color[] createRampColours(int numColours, float saturation, float brightness) {
        return ImageUtilities.createRampColours(numColours, 0.0f, 1.0f, saturation, brightness);
    }

    public static Color[] createRampColours(int numColours, float startHue, float endHue, float saturation, float brightness) {
        Color[] colors = new Color[numColours];
        float increment = numColours > 1 ? (endHue - startHue) / (float)(numColours - 1) : 0.0f;
        float hue = startHue;
        for (int i = 0; i < numColours; ++i) {
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            colors[i] = new Color(rgb);
            hue += increment;
        }
        return colors;
    }

    public static RenderedImage createDisplayImage(RenderedImage dataImg, Map<Integer, Color> colourTable) {
        if (colourTable.size() > 256) {
            throw new IllegalArgumentException("Number of colours can't be more than 256");
        }
        Integer maxKey = null;
        Integer minKey = null;
        for (Integer key : colourTable.keySet()) {
            if (minKey == null) {
                minKey = maxKey = key;
                continue;
            }
            if (key < minKey) {
                minKey = key;
                continue;
            }
            if (key <= maxKey) continue;
            maxKey = key;
        }
        ParameterBlockJAI pb = null;
        RenderedImage lookupImg = dataImg;
        byte[][] lookup = null;
        int offset = 0;
        if (minKey < 0 || maxKey > 255) {
            lookupImg = ImageUtilities.createConstantImage(dataImg.getWidth(), dataImg.getHeight(), 0);
            TreeMap keyTable = new TreeMap();
            int k = 0;
            for (Integer key : colourTable.keySet()) {
                keyTable.put(key, k++);
            }
            WritableRectIter iter = RectIterFactory.createWritable((WritableRenderedImage)((TiledImage)lookupImg), null);
            while (true) {
                iter.setSample(((Integer)keyTable.get(iter.getSample())).intValue());
                if (!iter.nextPixelDone()) continue;
                iter.startPixels();
                if (!iter.nextLineDone()) continue;
                iter.startLines();
                if (iter.nextBandDone()) break;
            }
            lookup = new byte[3][colourTable.size()];
            for (Integer key : keyTable.keySet()) {
                int index = (Integer)keyTable.get(key);
                int colour = colourTable.get(key).getRGB();
                lookup[0][index] = (byte)((colour & 0xFF0000) >> 16);
                lookup[1][index] = (byte)((colour & 0xFF00) >> 8);
                lookup[2][index] = (byte)(colour & 0xFF);
            }
        } else {
            lookup = new byte[3][maxKey - minKey + 1];
            offset = minKey;
            for (Integer key : colourTable.keySet()) {
                int colour = colourTable.get(key).getRGB();
                lookup[0][key.intValue() - offset] = (byte)((colour & 0xFF0000) >> 16);
                lookup[1][key.intValue() - offset] = (byte)((colour & 0xFF00) >> 8);
                lookup[2][key.intValue() - offset] = (byte)(colour & 0xFF);
            }
        }
        pb = new ParameterBlockJAI("Lookup");
        pb.setSource("source0", (Object)lookupImg);
        pb.setParameter("table", (Object)new LookupTableJAI(lookup, offset));
        RenderedOp displayImg = JAI.create((String)"Lookup", (ParameterBlock)pb);
        return displayImg;
    }

    public static List<RenderedImage> getBandsAsImages(RenderedImage img) {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        if (img != null) {
            int numBands = img.getSampleModel().getNumBands();
            int band = 0;
            while (band < numBands) {
                ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
                pb.setSource("source0", (Object)img);
                pb.setParameter("bandindices", (Object)new int[]{band++});
                RenderedOp bandImg = JAI.create((String)"BandSelect", (ParameterBlock)pb);
                images.add((RenderedImage)bandImg);
            }
        }
        return images;
    }

    public static List<RenderedImage> getBandsAsImages(RenderedImage img, Collection<Integer> bandIndices) {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        if (img != null) {
            int numBands = img.getSampleModel().getNumBands();
            TreeSet<Integer> sortedIndices = new TreeSet<Integer>();
            sortedIndices.addAll(bandIndices);
            if ((Integer)sortedIndices.first() < 0 || (Integer)sortedIndices.last() >= numBands) {
                throw new IllegalArgumentException("band index out of bounds");
            }
            for (Integer band : sortedIndices) {
                ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
                pb.setSource("source0", (Object)img);
                pb.setParameter("bandindices", (Object)new int[]{band});
                RenderedOp bandImg = JAI.create((String)"BandSelect", (ParameterBlock)pb);
                images.add((RenderedImage)bandImg);
            }
        }
        return images;
    }

    private static void fillRaster(WritableRaster wr, int w, int h, int dataType, Object typedValues) {
        switch (dataType) {
            case 5: {
                double[] values = (double[])typedValues;
                ImageUtilities.fillRasterDouble(wr, w, h, values);
                break;
            }
            case 4: {
                float[] values = (float[])typedValues;
                ImageUtilities.fillRasterFloat(wr, w, h, values);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                int[] values = (int[])typedValues;
                ImageUtilities.fillRasterInt(wr, w, h, values);
            }
        }
    }

    private static void fillRasterDouble(WritableRaster wr, int w, int h, double[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }

    private static void fillRasterFloat(WritableRaster wr, int w, int h, float[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }

    private static void fillRasterInt(WritableRaster wr, int w, int h, int[] values) {
        WritableRaster child = wr.createWritableTranslatedChild(0, 0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                child.setPixel(x, y, values);
            }
        }
    }

    static {
        boolean mediaLib = false;
        Class<?> mediaLibImage = null;
        try {
            mediaLibImage = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.newInstance();
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
    }
}

