/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.DirectPosition3D;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;
    CoordinateFormatter formatter;

    public DirectPositionTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    public DirectPositionTypeBinding(GeometryFactory factory, CoordinateFormatter formatter) {
        this.factory = factory;
        this.formatter = formatter;
    }

    public QName getTarget() {
        return GML.DirectPositionType;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] position = (Double[])value;
        Object dp = null;
        if (position.length < 2) {
            dp = crs != null ? new DirectPosition1D(crs) : new DirectPosition1D();
            dp.setOrdinate(0, position[0].doubleValue());
        } else if (position.length < 3) {
            dp = crs != null ? new DirectPosition2D(crs) : new DirectPosition2D();
            dp.setOrdinate(0, position[0].doubleValue());
            dp.setOrdinate(1, position[1].doubleValue());
        } else {
            dp = crs != null ? new DirectPosition3D(crs) : new DirectPosition3D();
            dp.setOrdinate(0, position[0].doubleValue());
            dp.setOrdinate(1, position[1].doubleValue());
            dp.setOrdinate(2, position[2].doubleValue());
        }
        return dp;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence cs = (CoordinateSequence)object;
        StringBuffer sb = new StringBuffer();
        if (cs.size() >= 1) {
            int dim = cs.getDimension();
            for (int d = 0; d < dim; ++d) {
                double v = cs.getOrdinate(0, d);
                if (Double.isNaN(v) && d > 1) continue;
                if (this.formatter != null) {
                    this.formatter.format(v, sb);
                } else {
                    sb.append(String.valueOf(v));
                }
                sb.append(" ");
            }
            if (dim > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

