/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class CurveEncoder
extends GeometryEncoder<LineString> {
    static final QualifiedName CURVE = new QualifiedName("http://www.opengis.net/gml", "Curve", "gml");
    static final QualifiedName SEGMENTS = new QualifiedName("http://www.opengis.net/gml", "segments", "gml");
    static final QualifiedName LINE_STRING_SEGMENT = new QualifiedName("http://www.opengis.net/gml", "LineStringSegment", "gml");
    static final QualifiedName ARC_STRING = new QualifiedName("http://www.opengis.net/gml", "ArcString", "gml");
    QualifiedName curve;
    QualifiedName segments;
    QualifiedName lineStringSegment;
    QualifiedName arcString;

    protected CurveEncoder(Encoder e, String gmlPrefix, String gmlUri) {
        super(e);
        this.curve = CURVE.derive(gmlPrefix, gmlUri);
        this.segments = SEGMENTS.derive(gmlPrefix, gmlUri);
        this.lineStringSegment = LINE_STRING_SEGMENT.derive(gmlPrefix, gmlUri);
        this.arcString = ARC_STRING.derive(gmlPrefix, gmlUri);
    }

    public void encode(LineString geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        if (gmlId != null) {
            atts = this.cloneWithGmlId(atts, gmlId);
        }
        handler.startElement(this.curve, (Attributes)atts);
        handler.startElement(this.segments, null);
        this.encodeContents(geometry, handler);
        handler.endElement(this.segments);
        handler.endElement(this.curve);
    }

    private void encodeContents(LineString geometry, GMLWriter handler) throws Exception {
        if (geometry instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry curve = (SingleCurvedGeometry)((Object)geometry);
            this.encodeCurve(curve, handler);
        } else if (geometry instanceof CompoundCurvedGeometry) {
            CompoundCurvedGeometry compound = (CompoundCurvedGeometry)((Object)geometry);
            for (LineString component : compound.getComponents()) {
                this.encodeContents(component, handler);
            }
        } else {
            this.encodeLinestring(geometry, handler);
        }
    }

    private void encodeLinestring(LineString geometry, GMLWriter handler) throws Exception {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://www.opengis.net/gml", "interpolation", "interpolation", "", "linear");
        handler.startElement(this.lineStringSegment, (Attributes)atts);
        handler.posList(geometry.getCoordinateSequence());
        handler.endElement(this.lineStringSegment);
    }

    private void encodeCurve(SingleCurvedGeometry curve, GMLWriter handler) throws Exception {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://www.opengis.net/gml", "interpolation", "interpolation", "", "circularArc3Points");
        handler.startElement(this.arcString, (Attributes)atts);
        handler.posList((CoordinateSequence)new LiteCoordinateSequence(curve.getControlPoints()));
        handler.endElement(this.arcString);
    }
}

