/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class MultiLineStringEncoder
extends GeometryEncoder<Geometry> {
    static final QualifiedName MULTI_CURVE = new QualifiedName("http://www.opengis.net/gml", "MultiCurve", "gml");
    static final QualifiedName CURVE_MEMBER = new QualifiedName("http://www.opengis.net/gml", "curveMember", "gml");
    static final QualifiedName MULTI_LINE_STRING = new QualifiedName("http://www.opengis.net/gml", "MultiLineString", "gml");
    static final QualifiedName LINE_STRING_MEMBER = new QualifiedName("http://www.opengis.net/gml", "lineStringMember", "gml");
    LineStringEncoder lse;
    LinearRingEncoder lre;
    CurveEncoder ce;
    QualifiedName multiContainer;
    QualifiedName member;
    boolean curveEncoding;

    protected MultiLineStringEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean curveEncoding) {
        super(encoder);
        this.lse = new LineStringEncoder(encoder, gmlPrefix, gmlUri);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix, gmlUri);
        this.ce = new CurveEncoder(encoder, gmlPrefix, gmlUri);
        this.curveEncoding = curveEncoding;
        if (curveEncoding) {
            this.multiContainer = MULTI_CURVE.derive(gmlPrefix, gmlUri);
            this.member = CURVE_MEMBER.derive(gmlPrefix, gmlUri);
        } else {
            this.multiContainer = MULTI_LINE_STRING.derive(gmlPrefix, gmlUri);
            this.member = LINE_STRING_MEMBER.derive(gmlPrefix, gmlUri);
        }
    }

    public void encode(Geometry geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.multiContainer, (Attributes)atts);
        this.encodeMembers(geometry, handler, gmlId);
        handler.endElement(this.multiContainer);
    }

    protected void encodeMembers(Geometry geometry, GMLWriter handler, String gmlId) throws SAXException, Exception {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.member, null);
            LineString line = (LineString)geometry.getGeometryN(i);
            String childId = gmlId + "." + (i + 1);
            if (this.curveEncoding && line instanceof CurvedGeometry) {
                this.ce.encode(line, null, handler, childId);
            } else if (line instanceof LinearRing) {
                this.lre.encode(line, null, handler, childId);
            } else {
                this.lse.encode(line, null, handler, childId);
            }
            handler.endElement(this.member);
        }
    }
}

