/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class MultiPointEncoder
extends GeometryEncoder<MultiPoint> {
    static final QualifiedName MULTI_POINT = new QualifiedName("http://www.opengis.net/gml", "MultiPoint", "gml");
    static final QualifiedName POINT_MEMBER = new QualifiedName("http://www.opengis.net/gml", "pointMember", "gml");
    PointEncoder pe;
    QualifiedName multiPoint;
    QualifiedName pointMember;

    protected MultiPointEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.pe = new PointEncoder(encoder, gmlPrefix, gmlUri);
        this.multiPoint = MULTI_POINT.derive(gmlPrefix, gmlUri);
        this.pointMember = POINT_MEMBER.derive(gmlPrefix, gmlUri);
    }

    public void encode(MultiPoint geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.multiPoint, (Attributes)atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.pointMember, null);
            this.pe.encode((Point)geometry.getGeometryN(i), null, handler, gmlId + "." + (i + 1));
            handler.endElement(this.pointMember);
        }
        handler.endElement(this.multiPoint);
    }
}

