/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class CurvedGeometries {
    public static boolean isCurved(Geometry geometry) {
        if (geometry instanceof CurvedGeometry) {
            return true;
        }
        final AtomicBoolean curveFound = new AtomicBoolean(false);
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geom) {
                if (geom instanceof CurvedGeometry) {
                    curveFound.set(true);
                }
            }
        });
        return curveFound.get();
    }

    public static boolean isCircle(Geometry geom) {
        if (geom.isEmpty()) {
            return false;
        }
        if (!(geom instanceof CircularRing) && !(geom instanceof CompoundRing)) {
            return false;
        }
        if (geom instanceof CircularRing) {
            CircularRing curved = (CircularRing)geom;
            CircularArc first = curved.getArcN(0);
            double radius = first.getRadius();
            if (radius == Double.POSITIVE_INFINITY) {
                return false;
            }
            Coordinate center = first.getCenter();
            int numArcs = curved.getNumArcs();
            for (int i = 1; i < numArcs; ++i) {
                CircularArc curr = curved.getArcN(i);
                if (!CircularArc.equals(curr.getRadius(), radius)) {
                    return false;
                }
                Coordinate cc = curr.getCenter();
                if (CircularArc.equals(cc.x, center.x) && CircularArc.equals(cc.y, center.y)) continue;
                return false;
            }
            return true;
        }
        CompoundRing curved = (CompoundRing)geom;
        List<LineString> components = curved.getComponents();
        double radius = Double.NaN;
        Coordinate center = null;
        for (LineString component : components) {
            if (!(component instanceof SingleCurvedGeometry)) {
                return false;
            }
            SingleCurvedGeometry curvedComponent = (SingleCurvedGeometry)((Object)component);
            int numArcs = curvedComponent.getNumArcs();
            for (int i = 0; i < numArcs; ++i) {
                CircularArc curr = curvedComponent.getArcN(i);
                if (center == null) {
                    radius = curr.getRadius();
                    if (radius == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    center = curr.getCenter();
                    continue;
                }
                if (!CircularArc.equals(curr.getRadius(), radius)) {
                    return false;
                }
                Coordinate cc = curr.getCenter();
                if (CircularArc.equals(cc.x, center.x) && CircularArc.equals(cc.y, center.y)) continue;
                return false;
            }
        }
        return true;
    }

    public static CircularArc getArc(CoordinateSequence cs, int startCoordinate) {
        if (cs.size() < startCoordinate + 3) {
            throw new IllegalArgumentException("The coordinate sequence has " + cs.size() + " points, cannot extract a circular arc starting from coordinate " + startCoordinate);
        }
        if (startCoordinate < 0) {
            throw new IllegalArgumentException("Start coordinate must be 0 or positive, not: " + startCoordinate);
        }
        return new CircularArc(cs.getOrdinate(0, 0), cs.getOrdinate(0, 1), cs.getOrdinate(1, 0), cs.getOrdinate(1, 1), cs.getOrdinate(2, 0), cs.getOrdinate(2, 1));
    }

    public static CircularRing toCircle(CircularArc arc, GeometryFactory geometryFactory, double tolerance) {
        double radius = arc.getRadius();
        Coordinate center = arc.getCenter();
        double[] rcp = new double[]{center.x + radius, center.y, center.x, center.y + radius, center.x - radius, center.y, center.x, center.y - radius, center.x + radius, center.y};
        return new CircularRing(rcp, geometryFactory, tolerance);
    }

    public static CurvedGeometryFactory getFactory(CurvedGeometry<?> curved) {
        CurvedGeometryFactory cf;
        GeometryFactory factory = ((Geometry)((Object)curved)).getFactory();
        if (factory instanceof CurvedGeometryFactory && (cf = (CurvedGeometryFactory)factory).getTolerance() == curved.getTolerance()) {
            return cf;
        }
        return new CurvedGeometryFactory(factory, curved.getTolerance());
    }
}

