/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.WKBReader;

public class WKBLoaderSPI
implements FootprintLoaderSpi {
    @Override
    public FootprintLoader createLoader() {
        return new WKBLoader();
    }

    public class WKBLoader
    implements FootprintLoader {
        WKBReader reader = new WKBReader();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkb");
            if (file.exists()) {
                Geometry geometry;
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    geometry = this.reader.read((InStream)new InputStreamInStream((InputStream)is));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                return geometry;
            }
            return null;
        }
    }
}

