/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle.sdo;

import java.util.logging.Logger;
import org.geotools.data.oracle.sdo.SDO;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SDOSqlDumper {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle.sdo");

    public static String toSDOGeom(Geometry geometry, int srid) {
        if (Point.class.isAssignableFrom(geometry.getClass())) {
            return SDOSqlDumper.toSDOGeom((Point)geometry, srid);
        }
        if (LineString.class.isAssignableFrom(geometry.getClass())) {
            return SDOSqlDumper.toSDOGeom((LineString)geometry, srid);
        }
        if (Polygon.class.isAssignableFrom(geometry.getClass())) {
            if (geometry.equalsTopo(geometry.getEnvelope())) {
                return SDOSqlDumper.toSDOGeom(geometry.getEnvelopeInternal(), srid);
            }
            return SDOSqlDumper.toSDOGeom((Polygon)geometry, srid);
        }
        if (MultiLineString.class.isAssignableFrom(geometry.getClass())) {
            return SDOSqlDumper.toSDOGeom((MultiLineString)geometry, srid);
        }
        if (MultiPolygon.class.isAssignableFrom(geometry.getClass())) {
            return SDOSqlDumper.toSDOGeom((MultiPolygon)geometry, srid);
        }
        LOGGER.warning("Got a literal geometry that I can't handle: " + geometry.getClass().getName());
        return "";
    }

    private static String toSDOGeom(MultiLineString line, int srid) {
        if (line.getNumGeometries() == 1) {
            return SDOSqlDumper.toSDOGeom(line.getGeometryN(0), srid);
        }
        throw new UnsupportedOperationException("Cannot encode MultiLineString (yet)");
    }

    private static String toSDOGeom(MultiPolygon polygon, int srid) {
        if (polygon.getNumGeometries() == 1) {
            return SDOSqlDumper.toSDOGeom(polygon.getGeometryN(0), srid);
        }
        throw new UnsupportedOperationException("Cannot encode MultiPolygon (yet)");
    }

    private static String toSDOGeom(LineString line, int srid) {
        if (SDO.D(line) > 2) {
            LOGGER.warning("" + SDO.D(line) + " dimensioned geometry provided. This encoder only supports 2D geometries. The query will be constructed as a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(SDO.D(line));
        buffer.append("002,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),");
        buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
        Coordinate[] coordinates = line.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            buffer.append(coordinates[i].x);
            buffer.append(",");
            buffer.append(coordinates[i].y);
            if (i == coordinates.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("))");
        return buffer.toString();
    }

    private static String toSDOGeom(Point point, int srid) {
        if (SDO.D(point) > 2) {
            LOGGER.warning("" + SDO.D(point) + " dimensioned geometry provided. This encoder only supports 2D geometries. The query will be constructed as a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(SDO.D(point));
        buffer.append("001,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",MDSYS.SDO_POINT_TYPE(");
        buffer.append(point.getX());
        buffer.append(",");
        buffer.append(point.getY());
        buffer.append(",NULL),NULL,NULL)");
        return buffer.toString();
    }

    private static String toSDOGeom(Polygon polygon, int srid) {
        StringBuffer buffer = new StringBuffer();
        if (SDO.D(polygon) > 2) {
            LOGGER.warning("" + SDO.D(polygon) + " dimensioned geometry provided. This encoder only supports 2D geometries. The query will be constructed as a 2D query.");
        }
        if (polygon.getExteriorRing() != null) {
            buffer.append("MDSYS.SDO_GEOMETRY(");
            buffer.append(SDO.D(polygon));
            buffer.append("003,");
            if (srid > 0) {
                LOGGER.fine("Using layer SRID: " + srid);
                buffer.append(srid);
            } else {
                LOGGER.fine("Using NULL SRID: ");
                buffer.append("NULL");
            }
            buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),");
            buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
            CoordinateSequenceFactory fact = polygon.getFactory().getCoordinateSequenceFactory();
            CoordinateSequence exterior = polygon.getExteriorRing().getCoordinateSequence();
            CoordinateSequence coordSeq = SDO.counterClockWise(fact, exterior);
            int size = coordSeq.size();
            for (int i = 0; i < size; ++i) {
                Coordinate cur = coordSeq.getCoordinate(i);
                buffer.append(cur.x);
                buffer.append(",");
                buffer.append(cur.y);
                if (i == size - 1) continue;
                buffer.append(",");
            }
            buffer.append("))");
        } else {
            LOGGER.warning("No Exterior ring on polygon.  This encode only supports Polygons with exterior rings.");
        }
        if (polygon.getNumInteriorRing() > 0) {
            LOGGER.warning("Polygon contains Interior Rings. These rings will not be included in the query.");
        }
        return buffer.toString();
    }

    private static String toSDOGeom(Envelope envelope, int srid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MDSYS.SDO_GEOMETRY(");
        buffer.append("2003,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3),");
        buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
        buffer.append(envelope.getMinX());
        buffer.append(",");
        buffer.append(envelope.getMinY());
        buffer.append(",");
        buffer.append(envelope.getMaxX());
        buffer.append(",");
        buffer.append(envelope.getMaxY());
        buffer.append("))");
        return buffer.toString();
    }
}

