/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import java.util.ArrayList;
import java.util.List;
import org.geotools.gml3.bindings.ext.CurvePropertyTypeBinding;
import org.geotools.gml3.bindings.ext.CurveTypeBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class MultiCurveTypeBinding
extends org.geotools.gml3.bindings.MultiCurveTypeBinding
implements Comparable {
    public MultiCurveTypeBinding(GeometryFactory gf) {
        super(gf);
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List curveMemberList = node.getChildValues("curveMember");
        Geometry curveMembers = (Geometry)node.getChildValue("curveMembers");
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        if (curveMemberList != null) {
            for (Geometry curveMember : curveMemberList) {
                for (int i = 0; i < curveMember.getNumGeometries(); ++i) {
                    LineString lineString = (LineString)curveMember.getGeometryN(i);
                    lineStrings.add(lineString);
                }
            }
        }
        if (curveMembers != null) {
            for (int i = 0; i < curveMembers.getNumGeometries(); ++i) {
                LineString lineString = (LineString)curveMembers.getGeometryN(i);
                lineStrings.add(lineString);
            }
        }
        return this.gf.createMultiLineString(GeometryFactory.toLineStringArray(lineStrings));
    }

    public int compareTo(Object o) {
        if (o instanceof CurveTypeBinding || o instanceof CurvePropertyTypeBinding) {
            return 1;
        }
        return 0;
    }
}

