/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.HTMLBuilder;
import it.geosolutions.rendered.viewer.HTMLRenderer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class HTMLRenderers {
    private static List<HTMLRenderer> renderers = new ArrayList<HTMLRenderer>();

    public static List<HTMLRenderer> getRenderers() {
        return renderers;
    }

    public static void addRendered(HTMLRenderer renderer) {
        renderers.add(renderer);
    }

    private HTMLRenderers() {
    }

    static {
        renderers.add(new ArrayRenderer());
    }

    private static class ArrayRenderer
    implements HTMLRenderer {
        private ArrayRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && o.getClass().isArray();
        }

        @Override
        public String render(Object o) {
            int length = Array.getLength(o);
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            for (int i = 0; i < length; ++i) {
                sb.append(HTMLBuilder.render(Array.get(o, i)));
                if (i < length - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

