/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.gml.light;

import java.util.HashMap;
import java.util.Map;
import nl.b3p.brmo.loader.gml.GMLLightFeatureTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

class GMLLightFeatureTransformerImpl
implements GMLLightFeatureTransformer {
    private static final Log LOG = LogFactory.getLog(GMLLightFeatureTransformerImpl.class);
    protected final HashMap<String, String> attrMapping = new HashMap();
    protected final HashMap<String, AttributeDescriptor> composedAttr = new HashMap();
    private final FeatureTypeFactory typeFactory = CommonFactoryFinder.getFeatureTypeFactory(null);
    private final AttributeTypeBuilder builder = new AttributeTypeBuilder();
    private CoordinateReferenceSystem crs = null;

    public GMLLightFeatureTransformerImpl() {
        this.attrMapping.put("name", null);
        this.attrMapping.put("description", null);
        this.attrMapping.put("boundedBy", null);
        this.attrMapping.put("metaDataProperty", null);
        this.attrMapping.put("inOnderzoek", null);
        this.attrMapping.put("tijdstipRegistratie", "tijdstip_registratie");
        this.attrMapping.put("eindRegistratie", null);
        this.attrMapping.put("LV-publicatiedatum", null);
        this.attrMapping.put("bronhouder", null);
        this.attrMapping.put("objectBeginTijd", "dat_beg_geldh");
        this.attrMapping.put("objectEindTijd", null);
        this.attrMapping.put("bgt-status", "bgt_status");
        this.attrMapping.put("plus-status", "plus_status");
        this.attrMapping.put("relatieveHoogteligging", "relve_hoogteligging");
        this.builder.setFactory(this.typeFactory);
        this.builder.name("identif").binding(String.class).identifiable(true).abstrct(false).minOccurs(1).maxOccurs(1).nillable(false).description("NEN3610 indentificatie");
        AttributeDescriptor NEN3610ID = this.builder.buildDescriptor("identif");
        this.composedAttr.put("identificatie.namespace+identificatie.lokaalID", NEN3610ID);
        try {
            this.crs = CRS.decode((String)"EPSG:28992");
        }
        catch (FactoryException ex) {
            LOG.warn((Object)"CRS opzoeken is mislukt", (Throwable)ex);
        }
    }

    @Override
    public SimpleFeatureType getTargetSchema(SimpleFeatureType gmlSchema, String targetTableName, boolean shouldUppercase) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        if (shouldUppercase) {
            tb.setName(targetTableName.toUpperCase());
        } else {
            tb.setName(targetTableName);
        }
        tb.setCRS(this.crs);
        tb.setSRS("EPSG:28992");
        tb.setNamespaceURI((String)null);
        tb.setDescription((InternationalString)new SimpleInternationalString("RSGB 3.0 BGT " + gmlSchema.getTypeName()));
        AttributeTypeBuilder bldr = new AttributeTypeBuilder();
        for (AttributeDescriptor attr : this.composedAttr.values()) {
            if (shouldUppercase) {
                tb.srid(Integer.valueOf(28992)).add(bldr.init(attr.getType()).name(attr.getLocalName().toUpperCase()).defaultValue(attr.getDefaultValue()).buildDescriptor(attr.getLocalName().toUpperCase()));
                continue;
            }
            tb.srid(Integer.valueOf(28992)).add(attr);
        }
        for (AttributeDescriptor att : gmlSchema.getAttributeDescriptors()) {
            String gmlAttrLocalName = att.getLocalName();
            if (gmlAttrLocalName == null) {
                LOG.warn((Object)("'Null' local name van attribuut " + att));
                gmlAttrLocalName = att.toString();
            }
            String dbAttrName = this.attrMapping.get(gmlAttrLocalName);
            LOG.debug((Object)("aanmaken AttributeDescriptor voor: " + gmlAttrLocalName + " (wordt: " + dbAttrName + ")"));
            if (dbAttrName == null) continue;
            if (shouldUppercase) {
                dbAttrName = dbAttrName.toUpperCase();
            }
            if (dbAttrName.equals(gmlAttrLocalName)) {
                tb.srid(Integer.valueOf(28992)).add(att);
            } else {
                tb.srid(Integer.valueOf(28992)).add(bldr.init(att.getType()).name(dbAttrName).defaultValue(att.getDefaultValue()).buildDescriptor(dbAttrName));
            }
            if (dbAttrName.equals("geom2d")) {
                tb.setDefaultGeometry("geom2d");
            }
            if (!dbAttrName.equals("geom2d".toUpperCase())) continue;
            tb.setDefaultGeometry("geom2d".toUpperCase());
        }
        return tb.crs(this.crs).buildFeatureType();
    }

    @Override
    public SimpleFeature transform(SimpleFeature inFeature, SimpleFeatureType targetType, boolean shouldUppercaseFieldnames, boolean userDefinedPrimaryKey) {
        String targetAttrName;
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(targetType);
        for (String key : this.attrMapping.keySet()) {
            targetAttrName = this.attrMapping.get(key);
            if (targetAttrName == null) continue;
            if (shouldUppercaseFieldnames) {
                targetAttrName = targetAttrName.toUpperCase();
            }
            featureBuilder.set(targetAttrName, inFeature.getAttribute(key));
        }
        String id = null;
        for (Map.Entry<String, AttributeDescriptor> e : this.composedAttr.entrySet()) {
            targetAttrName = e.getValue().getLocalName();
            if (shouldUppercaseFieldnames) {
                targetAttrName = targetAttrName.toUpperCase();
            }
            String[] keys = e.getKey().split("\\+");
            StringBuilder composition = new StringBuilder();
            for (String key : keys) {
                composition.append(inFeature.getAttribute(key)).append(":");
            }
            String composed = composition.substring(0, composition.length() - 1);
            featureBuilder.set(targetAttrName, (Object)composed);
            if (!targetAttrName.equalsIgnoreCase("identif")) continue;
            id = composed;
        }
        featureBuilder.featureUserData((Object)Hints.USE_PROVIDED_FID, (Object)userDefinedPrimaryKey);
        return featureBuilder.buildFeature(id);
    }
}

