/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.ows.ServiceException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ServiceExceptionParser {
    public static ServiceException parse(InputStream inputStream) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        Document document = builder.build(inputStream);
        Element root = document.getRootElement();
        List serviceExceptions = root.getChildren("ServiceException");
        List parsedExceptions = serviceExceptions.stream().map(ServiceExceptionParser::parseSE).sorted(ServiceExceptionParser::compare).collect(Collectors.toList());
        ServiceException firstException = null;
        ServiceException recentException = null;
        for (ServiceException exception : parsedExceptions) {
            if (firstException == null) {
                firstException = exception;
                recentException = exception;
                continue;
            }
            recentException.setNext(exception);
            recentException = exception;
        }
        return firstException;
    }

    private static ServiceException parseSE(Element element) {
        String errorMessage = element.getText();
        String code = element.getAttributeValue("code");
        return new ServiceException(errorMessage, code);
    }

    private static int sortValue(ServiceException exception) {
        return exception.getCode() != null && !exception.getCode().isEmpty() ? 0 : 1;
    }

    private static int compare(ServiceException exception1, ServiceException exception2) {
        return ServiceExceptionParser.sortValue(exception1) - ServiceExceptionParser.sortValue(exception2);
    }
}

