/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.util.logging.Logger;
import org.geotools.gml.producer.CoordinateWriter;
import org.geotools.gml.producer.GMLUtils;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GeometryTransformer
extends TransformerBase {
    static final Logger LOGGER = Logging.getLogger(GeometryTransformer.class);
    protected boolean useDummyZ = false;
    protected int numDecimals = 4;
    protected boolean padWithZeros = false;
    protected boolean forceDecimalEncoding = false;

    public void setUseDummyZ(boolean flag) {
        this.useDummyZ = flag;
    }

    public void setNumDecimals(int num) {
        this.numDecimals = num;
    }

    public void setPadWithZeros(boolean padWithZeros) {
        this.padWithZeros = padWithZeros;
    }

    public void setForceDecimalEncoding(boolean forceDecimalEncoding) {
        this.forceDecimalEncoding = forceDecimalEncoding;
    }

    @Override
    public Translator createTranslator(ContentHandler handler) {
        return new GeometryTranslator(handler, this.numDecimals, this.padWithZeros, this.forceDecimalEncoding, this.useDummyZ);
    }

    public static class GeometryTranslator
    extends TransformerBase.TranslatorSupport {
        protected CoordinateWriter coordWriter = new CoordinateWriter();

        public GeometryTranslator(ContentHandler handler) {
            this(handler, "gml", "http://www.opengis.net/gml");
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri) {
            super(handler, prefix, nsUri);
            this.coordWriter.setPrefix(prefix);
            this.coordWriter.setNamespaceUri(nsUri);
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals) {
            this(handler, "gml", "http://www.opengis.net/gml", numDecimals, false, false);
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri, int numDecimals) {
            this(handler, prefix, nsUri, numDecimals, false, false);
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals, boolean isDummyZEnabled) {
            this(handler, numDecimals, false, false, isDummyZEnabled);
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals, boolean padWithZeros, boolean forceDecimalEncoding) {
            this(handler, "gml", "http://www.opengis.net/gml", numDecimals, padWithZeros, forceDecimalEncoding);
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri, int numDecimals, boolean isDummyZEnabled) {
            this(handler, prefix, nsUri, numDecimals, false, false, isDummyZEnabled);
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri, int numDecimals, boolean padWithZeros, boolean forceDecimalEncoding) {
            this(handler, prefix, nsUri);
            this.coordWriter = new CoordinateWriter(numDecimals, padWithZeros, forceDecimalEncoding, false);
            this.coordWriter.setPrefix(prefix);
            this.coordWriter.setNamespaceUri(nsUri);
        }

        public GeometryTranslator(ContentHandler handler, int numDecimals, boolean padWithZeros, boolean forceDecimalEncoding, boolean isDummyZEnabled) {
            this(handler, "gml", "http://www.opengis.net/gml", numDecimals, padWithZeros, forceDecimalEncoding, isDummyZEnabled);
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri, int numDecimals, boolean padWithZeros, boolean forceDecimalEncoding, boolean isDummyZEnabled) {
            this(handler, prefix, nsUri);
            this.coordWriter = new CoordinateWriter(numDecimals, padWithZeros, forceDecimalEncoding, isDummyZEnabled);
            this.coordWriter.setPrefix(prefix);
            this.coordWriter.setNamespaceUri(nsUri);
        }

        public GeometryTranslator(ContentHandler handler, String prefix, String nsUri, int numDecimals, boolean padWithZeros, boolean forceDecimalEncoding, boolean isDummyZEnabled, int dimension) {
            this(handler, prefix, nsUri);
            this.coordWriter = new CoordinateWriter(numDecimals, padWithZeros, forceDecimalEncoding, isDummyZEnabled, dimension);
            this.coordWriter.setPrefix(prefix);
            this.coordWriter.setNamespaceUri(nsUri);
        }

        public boolean isDummyZEnabled() {
            return this.coordWriter.isDummyZEnabled();
        }

        public int getNumDecimals() {
            return this.coordWriter.getNumDecimals();
        }

        public boolean getPadWithZeros() {
            return this.coordWriter.getPadWithZeros();
        }

        public boolean getForceDecimalEncoding() {
            return this.coordWriter.getForceDecimalEncoding();
        }

        public void encode(Object o, String srsName) throws IllegalArgumentException {
            if (!(o instanceof Geometry)) {
                throw new IllegalArgumentException("Unable to encode " + o);
            }
            this.encode((Geometry)o, srsName);
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            this.encode(o, null);
        }

        public void encode(Envelope bounds) {
            this.encode(bounds, (String)null);
        }

        public void encode(Envelope bounds, String srsName) {
            if (bounds == null || bounds.isNull()) {
                this.encodeNullBounds();
                return;
            }
            String boxName = this.boxName();
            if (srsName == null || srsName.equals("")) {
                this.start(boxName);
            } else {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "srsName", "srsName", "", srsName);
                this.start(boxName, atts);
            }
            try {
                double[] coords = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
                PackedCoordinateSequence.Double coordSeq = new PackedCoordinateSequence.Double(coords, 2, 0);
                this.coordWriter.writeCoordinates((CoordinateSequence)coordSeq, this.contentHandler);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
            this.end(boxName);
        }

        protected void encodeNullBounds() {
            this.start("null");
            String text = "unknown";
            try {
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
            }
            catch (Exception e) {
                System.out.println("got exception while writing null boundedby:" + e.getLocalizedMessage());
                e.printStackTrace();
            }
            this.end("null");
        }

        protected String boxName() {
            return "Box";
        }

        public void encode(Geometry geometry) {
            String srsName = null;
            if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                try {
                    CoordinateReferenceSystem crs = (CoordinateReferenceSystem)geometry.getUserData();
                    Integer code = CRS.lookupEpsgCode(crs, false);
                    if (code != null) {
                        srsName = CRS.AxisOrder.NORTH_EAST.equals((Object)CRS.getAxisOrder(crs)) ? "urn:ogc:def:crs:EPSG::" + code : "EPSG:" + code;
                    }
                }
                catch (Exception e) {
                    LOGGER.fine("Failed to encode the CoordinateReferenceSystem into a srsName");
                }
            }
            this.encode(geometry, srsName);
        }

        public void encode(Geometry geometry, String srsName) {
            this.encode(geometry, srsName, 2);
        }

        public void encode(Geometry geometry, String srsName, int dimensions) {
            String geomName = GMLUtils.getGeometryName(geometry);
            if (srsName == null || srsName.equals("")) {
                this.start(geomName);
            } else {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "srsName", "srsName", "", srsName);
                this.start(geomName, atts);
            }
            int geometryType = GMLUtils.getGeometryType(geometry);
            switch (geometryType) {
                case 1: {
                    CoordinateSequence coordSeq = ((Point)geometry).getCoordinateSequence();
                    try {
                        this.coordWriter.writeCoordinates(coordSeq, this.contentHandler);
                        break;
                    }
                    catch (SAXException e) {
                        throw new RuntimeException(e);
                    }
                }
                case 2: {
                    CoordinateSequence coordSeq = ((LineString)geometry).getCoordinateSequence();
                    try {
                        this.coordWriter.writeCoordinates(coordSeq, this.contentHandler);
                        break;
                    }
                    catch (SAXException s) {
                        throw new RuntimeException(s);
                    }
                }
                case 3: {
                    this.writePolygon((Polygon)geometry);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.writeMulti((GeometryCollection)geometry, GMLUtils.getMemberName(geometryType));
                }
            }
            this.end(geomName);
        }

        private void writePolygon(Polygon geometry) {
            CoordinateSequence coordSeq;
            String outBound = "outerBoundaryIs";
            String lineRing = "LinearRing";
            String inBound = "innerBoundaryIs";
            this.start(outBound);
            this.start(lineRing);
            try {
                coordSeq = geometry.getExteriorRing().getCoordinateSequence();
                this.coordWriter.writeCoordinates(coordSeq, this.contentHandler);
            }
            catch (SAXException s) {
                throw new RuntimeException(s);
            }
            this.end(lineRing);
            this.end(outBound);
            int ii = geometry.getNumInteriorRing();
            for (int i = 0; i < ii; ++i) {
                this.start(inBound);
                this.start(lineRing);
                try {
                    coordSeq = geometry.getInteriorRingN(i).getCoordinateSequence();
                    this.coordWriter.writeCoordinates(coordSeq, this.contentHandler);
                }
                catch (SAXException s) {
                    throw new RuntimeException(s);
                }
                this.end(lineRing);
                this.end(inBound);
            }
        }

        private void writeMulti(GeometryCollection geometry, String member) {
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.start(member);
                this.encode(geometry.getGeometryN(i));
                this.end(member);
            }
        }
    }
}

