/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.reflect.Array;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class ArrayConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source.isArray() && !target.isArray() && source.getComponentType().isAssignableFrom(target)) {
            return new ArrayToSingleConverter();
        }
        if (target.isArray() && !source.isArray() && target.getComponentType().isAssignableFrom(source)) {
            return new SingleToArrayConverter();
        }
        return null;
    }

    private static class SingleToArrayConverter
    implements Converter {
        private SingleToArrayConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Object result = Array.newInstance(target.getComponentType(), 1);
            Array.set(result, 0, source);
            return (T)result;
        }
    }

    private static class ArrayToSingleConverter
    implements Converter {
        private ArrayToSingleConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (Array.getLength(source) != 1) {
                return null;
            }
            return (T)Array.get(source, 0);
        }
    }
}

