/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.GenericGeometryEncoder;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.GeometryCollection;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class GeometryCollectionEncoder
extends GeometryEncoder<GeometryCollection> {
    static final QualifiedName MULTI_GEOMETRY = new QualifiedName("http://www.opengis.net/gml", "MultiGeometry", "gml");
    static final QualifiedName GEOMETRY_MEMBER = new QualifiedName("http://www.opengis.net/gml", "geometryMember", "gml");
    QualifiedName multiGeometry;
    QualifiedName geometryMember;
    GenericGeometryEncoder gge;

    protected GeometryCollectionEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.gge = new GenericGeometryEncoder(encoder, gmlPrefix, gmlUri);
        this.init(gmlPrefix, gmlUri);
    }

    protected GeometryCollectionEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean encodeGmlId) {
        super(encoder, encodeGmlId);
        this.gge = new GenericGeometryEncoder(encoder, gmlPrefix, gmlUri, encodeGmlId);
        this.init(gmlPrefix, gmlUri);
    }

    private void init(String gmlPrefix, String gmlUri) {
        this.multiGeometry = MULTI_GEOMETRY.derive(gmlPrefix, gmlUri);
        this.geometryMember = GEOMETRY_MEMBER.derive(gmlPrefix, gmlUri);
    }

    public void encode(GeometryCollection geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.multiGeometry, (Attributes)atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.geometryMember, null);
            this.gge.encode(geometry.getGeometryN(i), null, handler, gmlId + "." + (i + 1));
            handler.endElement(this.geometryMember);
        }
        handler.endElement(this.multiGeometry);
    }
}

