/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.RingEncoder;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PolygonEncoder
extends GeometryEncoder<Polygon> {
    static final QualifiedName POLYGON = new QualifiedName("http://www.opengis.net/gml", "Polygon", "gml");
    static final QualifiedName EXTERIOR = new QualifiedName("http://www.opengis.net/gml", "exterior", "gml");
    static final QualifiedName INTERIOR = new QualifiedName("http://www.opengis.net/gml", "interior", "gml");
    QualifiedName polygon;
    QualifiedName exterior;
    QualifiedName interior;
    LinearRingEncoder lre;
    RingEncoder re;

    protected PolygonEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.init(encoder, gmlPrefix, gmlUri);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix, gmlUri);
        this.re = new RingEncoder(encoder, gmlPrefix, gmlUri);
    }

    protected PolygonEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean encodeGmlId) {
        super(encoder, encodeGmlId);
        this.init(encoder, gmlPrefix, gmlUri);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix, gmlUri, encodeGmlId);
        this.re = new RingEncoder(encoder, gmlPrefix, gmlUri, encodeGmlId);
    }

    private void init(Encoder encoder, String gmlPrefix, String gmlUri) {
        this.polygon = POLYGON.derive(gmlPrefix, gmlUri);
        this.exterior = EXTERIOR.derive(gmlPrefix, gmlUri);
        this.interior = INTERIOR.derive(gmlPrefix, gmlUri);
    }

    public void encode(Polygon geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.polygon, (Attributes)atts);
        handler.startElement(this.exterior, null);
        this.encodeRing(geometry.getExteriorRing(), handler, gmlId + ".1");
        handler.endElement(this.exterior);
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            handler.startElement(this.interior, null);
            this.encodeRing(geometry.getInteriorRingN(i), handler, gmlId + "." + (i + 2));
            handler.endElement(this.interior);
        }
        handler.endElement(this.polygon);
    }

    private void encodeRing(LineString ring, GMLWriter handler, String gmlId) throws Exception {
        if (ring instanceof CurvedGeometry) {
            this.re.encode(ring, null, handler, gmlId);
        } else {
            this.lre.encode(ring, null, handler, gmlId);
        }
    }
}

