/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers.properties;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.dbutils.PropertyHandler;

public class DatePropertyHandler
implements PropertyHandler {
    @Override
    public boolean match(Class<?> parameter, Object value) {
        if (value instanceof Date) {
            String targetType = parameter.getName();
            if ("java.sql.Date".equals(targetType)) {
                return true;
            }
            if ("java.sql.Time".equals(targetType)) {
                return true;
            }
            if ("java.sql.Timestamp".equals(targetType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object apply(Class<?> parameter, Object value) {
        String targetType = parameter.getName();
        if ("java.sql.Date".equals(targetType)) {
            value = new java.sql.Date(((Date)value).getTime());
        } else if ("java.sql.Time".equals(targetType)) {
            value = new Time(((Date)value).getTime());
        } else if ("java.sql.Timestamp".equals(targetType)) {
            Timestamp tsValue = (Timestamp)value;
            int nanos = tsValue.getNanos();
            value = new Timestamp(tsValue.getTime());
            ((Timestamp)value).setNanos(nanos);
        }
        return value;
    }
}

