/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

class NullHandlingVisitor
extends DuplicatingFilterVisitor {
    private FeatureType schema;

    public NullHandlingVisitor(FeatureType schema) {
        this.schema = schema;
    }

    public NullHandlingVisitor() {
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    private Object guardAgainstNulls(BinaryComparisonOperator clone) {
        Filter result = this.guardAgainstNulls((Filter)clone, clone.getExpression1());
        result = this.guardAgainstNulls(result, clone.getExpression2());
        return result;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        PropertyIsLike clone = (PropertyIsLike)super.visit(filter, extraData);
        return this.guardAgainstNulls((Filter)filter, clone.getExpression());
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        PropertyIsBetween clone = (PropertyIsBetween)super.visit(filter, extraData);
        Filter f = this.guardAgainstNulls((Filter)clone, clone.getExpression());
        f = this.guardAgainstNulls(f, clone.getLowerBoundary());
        f = this.guardAgainstNulls(f, clone.getUpperBoundary());
        return f;
    }

    private Filter guardAgainstNulls(Filter filter, Expression potentialPropertyName) {
        PropertyName pn;
        String name;
        if (potentialPropertyName instanceof PropertyName && this.isNillable(name = (pn = (PropertyName)potentialPropertyName).getPropertyName())) {
            Not notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(name)));
            if (filter instanceof And) {
                And and = (And)filter;
                ArrayList<Not> children = new ArrayList<Not>(and.getChildren());
                children.add(notNull);
                return this.ff.and(children);
            }
            return this.ff.and(filter, (Filter)notNull);
        }
        return filter;
    }

    private boolean isNillable(String name) {
        if (this.schema == null) {
            return true;
        }
        PropertyDescriptor descriptor = this.schema.getDescriptor(name);
        return descriptor == null || descriptor.isNillable();
    }
}

