/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.Point;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PointEncoder
extends GeometryEncoder<Point> {
    static final QualifiedName POINT = new QualifiedName("http://www.opengis.net/gml", "Point", "gml");
    static final QualifiedName POS = new QualifiedName("http://www.opengis.net/gml", "pos", "gml");
    QualifiedName point;
    QualifiedName pos;

    protected PointEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.init(gmlPrefix, gmlUri);
    }

    protected PointEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean encodeGmlId) {
        super(encoder, encodeGmlId);
        this.init(gmlPrefix, gmlUri);
    }

    private void init(String gmlPrefix, String gmlUri) {
        this.point = POINT.derive(gmlPrefix, gmlUri);
        this.pos = POS.derive(gmlPrefix, gmlUri);
    }

    public void encode(Point geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.point, (Attributes)atts);
        handler.startElement(this.pos, null);
        handler.position(geometry.getCoordinateSequence());
        handler.endElement(this.pos);
        handler.endElement(this.point);
    }
}

