/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.Decoders;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

abstract class AbstractGeometryCollectionSqlServerDecoder
extends AbstractSqlServerDecoder {
    AbstractGeometryCollectionSqlServerDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.GEOMETRYCOLLECTION;
    }

    @Override
    protected Geometry<?> createNullGeometry(CoordinateReferenceSystem<?> crs) {
        return this.createGeometry(new ArrayList(), null);
    }

    @Override
    protected Geometry<?> createGeometry(SqlServerGeometry nativeGeom) {
        return this.createGeometry(nativeGeom, 0);
    }

    @Override
    protected Geometry<?> createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        int startChildIdx = shapeIndex + 1;
        ArrayList geometries = new ArrayList(nativeGeom.getNumShapes());
        for (int childIdx = startChildIdx; childIdx < nativeGeom.getNumShapes(); ++childIdx) {
            if (!nativeGeom.isParentShapeOf(shapeIndex, childIdx)) continue;
            AbstractSqlServerDecoder decoder = (AbstractSqlServerDecoder)Decoders.decoderFor(nativeGeom.getOpenGisTypeOfShape(childIdx));
            Geometry<?> geometry = decoder.createGeometry(nativeGeom, childIdx);
            geometries.add(geometry);
        }
        return this.createGeometry(geometries, nativeGeom);
    }

    protected abstract Geometry<?> createGeometry(List var1, SqlServerGeometry var2);
}

