/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.ObjectEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.util.Converters;
import org.geotools.xml.Binding;
import org.geotools.xml.Encoder;
import org.geotools.xml.EncoderDelegate;
import org.geotools.xml.SimpleBinding;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xs.bindings.XSStringBinding;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class FeatureCollectionEncoderDelegate
implements EncoderDelegate {
    Encoder encoder;
    GMLDelegate gml;
    SimpleFeatureCollection features;
    HashMap<Class, GeometryEncoder> geometryEncoders;
    NamespaceSupport namespaces;
    QName boundedBy;
    QName name;
    protected boolean encodeGeometryIds = false;

    protected FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder, GMLDelegate gml) {
        this.features = features;
        this.gml = gml;
        this.encoder = encoder;
        this.namespaces = encoder.getNamespaces();
        this.encoder = encoder;
        this.geometryEncoders = new HashMap();
        this.boundedBy = gml.getSchema().qName("boundedBy");
        this.name = gml.getSchema().qName("name");
        gml.registerGeometryEncoders(this.geometryEncoders, encoder);
    }

    public void encode(ContentHandler handler) throws Exception {
        GMLWriter output = new GMLWriter(handler, this.namespaces, this.gml.getNumDecimals(), this.gml.forceDecimalEncoding(), this.gml.padWithZeros(), this.gml.getGmlPrefix(), this.gml.getEncodeMeasures());
        boolean featureBounds = !this.encoder.getConfiguration().hasProperty(GMLConfiguration.NO_FEATURE_BOUNDS);
        try (SimpleFeatureIterator fi = this.features.features();){
            if (!fi.hasNext()) {
                return;
            }
            ObjectEncoder ee = this.gml.createEnvelopeEncoder(this.encoder);
            ee = this.gml.createEnvelopeEncoder(this.encoder);
            this.gml.startFeatures(output);
            AttributesImpl idatts = new AttributesImpl();
            this.gml.initFidAttribute(idatts);
            SimpleFeature f = (SimpleFeature)fi.next();
            FeatureTypeContextCache ftCache = new FeatureTypeContextCache();
            while (f != null) {
                if (GMLEncodingUtils.isJoinedFeature(f) && this.gml.supportsTuples()) {
                    SimpleFeature[] splitted = GMLEncodingUtils.splitJoinedFeature(f);
                    this.gml.startTuple(output);
                    for (SimpleFeature feature : splitted) {
                        this.encodeFeature(output, featureBounds, ee, idatts, feature, ftCache);
                    }
                    this.gml.endTuple(output);
                } else {
                    this.encodeFeature(output, featureBounds, ee, idatts, f, ftCache);
                }
                if (fi.hasNext()) {
                    f = (SimpleFeature)fi.next();
                    continue;
                }
                f = null;
            }
            this.gml.endFeatures(output);
        }
    }

    private void encodeFeature(GMLWriter output, boolean featureBounds, ObjectEncoder ee, AttributesImpl idatts, SimpleFeature f, FeatureTypeContextCache ftCache) throws SAXException, Exception {
        this.gml.startFeature(output);
        FeatureTypeContext ftContext = ftCache.getFeatureTypeContext(f);
        idatts.setValue(0, f.getID());
        output.startElement(ftContext.featureQualifiedName, idatts);
        for (AttributeContext attribute : ftContext.attributes) {
            BoundingBox value;
            QualifiedName name = attribute.name;
            Object value1 = null;
            AttributeDescriptor ad = null;
            if (this.boundedBy.equals(name) && featureBounds) {
                value1 = f.getBounds();
            } else {
                int idx = attribute.attributeIndex;
                value1 = f.getAttribute(idx);
                ad = f.getFeatureType().getDescriptor(idx);
            }
            if ((value = value1) == null) continue;
            String gmlId = this.encodeGeometryIds ? f.getID() + "." + name.getLocalPart() : null;
            this.encodeValue(output, ee, value, attribute, gmlId);
        }
        output.endElement(ftContext.featureQualifiedName);
        this.gml.endFeature(output);
    }

    private void encodeValue(GMLWriter output, ObjectEncoder ee, Object value, AttributeContext attribute, String featureId) throws SAXException, Exception {
        output.startElement(attribute.name, this.getPropertyAttributes(attribute.name, attribute.featureType, attribute.descriptor, value));
        if (value instanceof Geometry) {
            Geometry g = (Geometry)value;
            Integer dimension = GML2EncodingUtils.getGeometryDimension(g, this.encoder.getConfiguration());
            AttributesImpl atts = this.buildSrsAttributes(((GeometryDescriptor)attribute.descriptor).getCoordinateReferenceSystem(), dimension);
            GeometryEncoder geometryEncoder = this.getGeometryEncoder(value, attribute);
            geometryEncoder.encode(g, atts, output, featureId);
        } else if (value instanceof Envelope) {
            ReferencedEnvelope e = (ReferencedEnvelope)((Object)value);
            Integer dimension = GML2EncodingUtils.getEnvelopeDimension(e, this.encoder.getConfiguration());
            AttributesImpl atts = this.buildSrsAttributes(e.getCoordinateReferenceSystem(), dimension);
            ee.encode(e, atts, output);
        } else if (attribute.binding instanceof SimpleBinding) {
            this.encodeSimpleBinding(output, value, attribute.binding);
        } else {
            output.characters(value.toString());
        }
        output.endElement(attribute.name);
    }

    protected Attributes getPropertyAttributes(QualifiedName name, FeatureType featureType, AttributeDescriptor attribute, Object value) {
        return null;
    }

    private GeometryEncoder getGeometryEncoder(Object value, AttributeContext attribute) {
        Class<Object> clazz = value.getClass();
        if (MultiLineString.class.equals(clazz) && attribute.binding.getTarget().getLocalPart().startsWith("MultiCurve")) {
            clazz = MultiCurve.class;
        }
        GeometryEncoder encoder = this.geometryEncoders.get(clazz);
        while (encoder == null && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            encoder = this.geometryEncoders.get(clazz);
        }
        if (encoder == null) {
            throw new RuntimeException("Failed to find an appropriate geometry encoder for class " + value.getClass());
        }
        return encoder;
    }

    private AttributesImpl buildSrsAttributes(CoordinateReferenceSystem crs, Integer dimension) {
        AttributesImpl atts = null;
        if (crs != null || dimension != null) {
            atts = new AttributesImpl();
            if (crs != null) {
                this.gml.setSrsNameAttribute(atts, crs);
            }
            if (dimension != null) {
                this.gml.setGeometryDimensionAttribute(atts, dimension);
            }
        }
        return atts;
    }

    private void encodeSimpleBinding(GMLWriter output, Object value, Binding binding) throws Exception, SAXException {
        String encoded;
        Object converted;
        if (!binding.getType().isInstance(value) && (converted = Converters.convert(value, binding.getType())) != null) {
            value = converted;
        }
        if ((encoded = ((SimpleBinding)binding).encode(value, null)) != null) {
            output.characters(encoded);
        }
    }

    final class FeatureTypeContextCache {
        FeatureTypeContext last;
        Map<SimpleFeatureType, FeatureTypeContext> featureTypeContexts = new IdentityHashMap<SimpleFeatureType, FeatureTypeContext>();

        FeatureTypeContextCache() {
        }

        public FeatureTypeContext getFeatureTypeContext(SimpleFeature f) {
            if (this.last != null && this.last.isCompatible(f)) {
                return this.last;
            }
            FeatureTypeContext result = this.featureTypeContexts.get(f.getFeatureType());
            if (result == null) {
                result = new FeatureTypeContext(f, FeatureCollectionEncoderDelegate.this.gml);
                this.featureTypeContexts.put(f.getFeatureType(), result);
            }
            return result;
        }
    }

    final class FeatureTypeContext {
        private SimpleFeatureType featureType;
        private List<AttributeContext> attributes;
        private QualifiedName featureQualifiedName;

        public FeatureTypeContext(SimpleFeature f, GMLDelegate gml) {
            this.featureType = f.getFeatureType();
            QName featureName = new QName(this.featureType.getName().getNamespaceURI(), this.featureType.getName().getLocalPart());
            XSDElementDeclaration element = FeatureCollectionEncoderDelegate.this.encoder.getSchemaIndex().getElementDeclaration(featureName);
            if (element == null) {
                element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                element.setName(this.featureType.getName().getLocalPart());
                element.setTargetNamespace(this.featureType.getName().getNamespaceURI());
                element.setTypeDefinition(FeatureCollectionEncoderDelegate.this.encoder.getSchemaIndex().getTypeDefinition(GML.AbstractFeatureType));
            }
            BindingLoader bindingLoader = FeatureCollectionEncoderDelegate.this.encoder.getBindingLoader();
            List properties = gml.getFeatureProperties(f, element, FeatureCollectionEncoderDelegate.this.encoder);
            this.attributes = this.setupAttributeContexts(properties, this.featureType, bindingLoader);
            this.featureQualifiedName = this.getFeatureQualifiedName(featureName);
        }

        private List<AttributeContext> setupAttributeContexts(List properties, SimpleFeatureType schema, BindingLoader bindingLoader) {
            ArrayList<AttributeContext> attributes = new ArrayList<AttributeContext>(properties.size());
            List attributeDescriptors = schema.getAttributeDescriptors();
            for (Object[] o : properties) {
                Binding binding;
                int idx;
                String prefix;
                XSDParticle particle = (XSDParticle)o[0];
                XSDElementDeclaration content = (XSDElementDeclaration)particle.getContent();
                if (content.isElementDeclarationReference()) {
                    content = content.getResolvedElementDeclaration();
                }
                QualifiedName contentName = (prefix = FeatureCollectionEncoderDelegate.this.namespaces.getPrefix(content.getTargetNamespace())) != null ? QualifiedName.build(content.getTargetNamespace(), content.getName(), prefix) : new QualifiedName(content.getTargetNamespace(), content.getName());
                AttributeContext attribute = new AttributeContext(contentName);
                attribute.featureType = schema;
                attributes.add(attribute);
                attribute.attributeIndex = idx = this.getNameIndex(content.getName(), attributeDescriptors);
                if (idx != -1) {
                    attribute.descriptor = (AttributeDescriptor)attributeDescriptors.get(idx);
                }
                if (FeatureCollectionEncoderDelegate.this.name.equals(contentName)) {
                    attribute.binding = new XSStringBinding();
                    continue;
                }
                if (FeatureCollectionEncoderDelegate.this.boundedBy.equals(contentName)) continue;
                XSDTypeDefinition contentType = content.getTypeDefinition();
                if (contentType.getName() == null) {
                    while (contentType != null && contentType.getName() == null) {
                        XSDTypeDefinition baseType = contentType.getBaseType();
                        if (contentType.equals(baseType)) {
                            contentType = null;
                            continue;
                        }
                        contentType = baseType;
                    }
                }
                if (contentType == null || content.getName() == null) {
                    throw new IllegalArgumentException("Could not find non annonymous type");
                }
                QName contentTypeName = new QName(contentType.getTargetNamespace(), contentType.getName());
                attribute.binding = binding = bindingLoader.loadBinding(contentTypeName, FeatureCollectionEncoderDelegate.this.encoder.getContext());
            }
            return attributes;
        }

        private int getNameIndex(String name, List<AttributeDescriptor> attributeDescriptors) {
            for (int i = 0; i < attributeDescriptors.size(); ++i) {
                if (!name.equals(attributeDescriptors.get(i).getLocalName())) continue;
                return i;
            }
            return -1;
        }

        private QualifiedName getFeatureQualifiedName(QName featureName) {
            String featureNamespaceURI = featureName.getNamespaceURI();
            String featureLocalName = featureName.getLocalPart();
            String featurePrefix = FeatureCollectionEncoderDelegate.this.namespaces.getPrefix(featureNamespaceURI);
            QualifiedName featureQualifiedName = QualifiedName.build(featureNamespaceURI, featureLocalName, featurePrefix);
            return featureQualifiedName;
        }

        public boolean isCompatible(SimpleFeature sf) {
            SimpleFeatureType schema = sf.getFeatureType();
            return this.featureType == schema || this.featureType.equals(schema);
        }
    }

    static final class AttributeContext {
        QualifiedName name;
        int attributeIndex;
        Binding binding;
        AttributeDescriptor descriptor;
        FeatureType featureType;

        public AttributeContext(QualifiedName name) {
            this.name = name;
        }
    }
}

