/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.LinearRingEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.helpers.AttributesImpl;

class PolygonEncoder
extends GeometryEncoder<Polygon> {
    static final QualifiedName POLYGON = new QualifiedName("http://www.opengis.net/gml", "Polygon", "gml");
    static final QualifiedName OUTER_BOUNDARY = new QualifiedName("http://www.opengis.net/gml", "outerBoundaryIs", "gml");
    static final QualifiedName INNER_BOUNDARY = new QualifiedName("http://www.opengis.net/gml", "innerBoundaryIs", "gml");
    QualifiedName polygon;
    QualifiedName outerBoundary;
    QualifiedName innerBoundary;
    LinearRingEncoder lre;

    protected PolygonEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix);
        this.polygon = POLYGON.derive(gmlPrefix);
        this.outerBoundary = OUTER_BOUNDARY.derive(gmlPrefix);
        this.innerBoundary = INNER_BOUNDARY.derive(gmlPrefix);
    }

    @Override
    public void encode(Polygon geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.polygon, atts);
        handler.startElement(this.outerBoundary, null);
        this.lre.encode(geometry.getExteriorRing(), (AttributesImpl)null, handler);
        handler.endElement(this.outerBoundary);
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            handler.startElement(this.innerBoundary, null);
            this.lre.encode(geometry.getInteriorRingN(i), (AttributesImpl)null, handler);
            handler.endElement(this.innerBoundary);
        }
        handler.endElement(this.polygon);
    }
}

