/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.Types;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCReaderCallback;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.renderer.ScreenMap;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.operation.TransformException;

public class JDBCFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    protected static final Logger LOGGER = Logging.getLogger(JDBCFeatureReader.class);
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.jdbc.trace"));
    protected JDBCFeatureSource featureSource;
    protected JDBCDataStore dataStore;
    protected SimpleFeatureType featureType;
    protected GeometryFactory geometryFactory;
    protected Query query;
    protected Hints hints;
    protected ScreenMap screenMap;
    protected Transaction tx;
    protected Boolean next;
    private SimpleFeature nextFeature;
    protected SimpleFeatureBuilder builder;
    protected PrimaryKey pkey;
    protected Statement st;
    protected ResultSet rs;
    protected Connection cx;
    protected ResultSetMetaData md;
    protected Exception tracer;
    protected String[] columnNames;
    protected int offset = 0;
    protected JDBCReaderCallback callback = JDBCReaderCallback.NULL;

    public JDBCFeatureReader(String sql, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, Query query) throws SQLException {
        this.init(featureSource, featureType, query);
        this.cx = cx;
        this.st = cx.createStatement(1003, 1007);
        this.st.setFetchSize(featureSource.getDataStore().getFetchSize());
        ((BasicSQLDialect)featureSource.getDataStore().getSQLDialect()).onSelect(this.st, cx, featureType);
        this.runQuery(() -> this.st.executeQuery(sql), this.st);
    }

    public JDBCFeatureReader(PreparedStatement st, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, Query query) throws SQLException {
        this.init(featureSource, featureType, query);
        this.cx = cx;
        this.st = st;
        ((PreparedStatementSQLDialect)featureSource.getDataStore().getSQLDialect()).onSelect(st, cx, featureType);
        this.runQuery(st::executeQuery, st);
    }

    public JDBCFeatureReader(ResultSet rs, Connection cx, int offset, JDBCFeatureSource featureSource, SimpleFeatureType featureType, Query query) throws SQLException {
        this.init(featureSource, featureType, query);
        this.cx = cx;
        this.st = rs.getStatement();
        this.rs = rs;
        this.offset = offset;
    }

    protected void init(JDBCFeatureSource featureSource, SimpleFeatureType featureType, Query query) {
        Double linearizationTolerance;
        CoordinateSequenceFactory csFactory;
        if (TRACE_ENABLED.booleanValue()) {
            this.tracer = new Exception();
            this.tracer.fillInStackTrace();
        }
        this.featureSource = featureSource;
        this.dataStore = featureSource.getDataStore();
        this.featureType = featureType;
        this.tx = featureSource.getTransaction();
        this.query = query;
        this.hints = query != null ? query.getHints() : null;
        this.geometryFactory = (GeometryFactory)this.hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (this.geometryFactory == null && (csFactory = (CoordinateSequenceFactory)this.hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            this.geometryFactory = new GeometryFactory(csFactory);
        }
        if (this.geometryFactory == null) {
            this.geometryFactory = this.dataStore.getGeometryFactory();
        }
        if ((linearizationTolerance = (Double)this.hints.get((Object)Hints.LINEARIZATION_TOLERANCE)) != null) {
            this.geometryFactory = new CurvedGeometryFactory(this.geometryFactory, linearizationTolerance);
        }
        this.screenMap = (ScreenMap)this.hints.get((Object)Hints.SCREENMAP);
        FeatureFactory ff = (FeatureFactory)this.hints.get((Object)Hints.FEATURE_FACTORY);
        if (ff == null) {
            ff = featureSource.getDataStore().getFeatureFactory();
        }
        this.builder = new SimpleFeatureBuilder(featureType, ff);
        try {
            this.pkey = this.dataStore.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.callback = this.dataStore.getCallbackFactory().createReaderCallback();
        this.callback.init(this);
    }

    void runQuery(QueryRunner runner, Statement st) throws SQLException {
        this.callback.beforeQuery(st);
        try {
            this.rs = runner.run();
            this.callback.afterQuery(st);
        }
        catch (Exception e1) {
            this.callback.queryError(e1);
            try {
                this.close();
            }
            catch (IOException e2) {
                LOGGER.log(Level.FINE, "Failed to close the reader, moving on", e2);
            }
            throw new SQLException(e1);
        }
    }

    public JDBCFeatureReader(JDBCFeatureReader other) {
        this.featureType = other.featureType;
        this.dataStore = other.dataStore;
        this.featureSource = other.featureSource;
        this.tx = other.tx;
        this.hints = other.hints;
        this.geometryFactory = other.geometryFactory;
        this.builder = other.builder;
        this.st = other.st;
        this.rs = other.rs;
        this.md = other.md;
    }

    public void setNext(Boolean next) {
        this.next = next;
        if (next == null) {
            this.nextFeature = null;
        }
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public PrimaryKey getPrimaryKey() {
        return this.pkey;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public boolean hasNext() throws IOException {
        this.ensureOpen();
        if (this.next == null) {
            try {
                while (this.nextFeature == null && !Boolean.FALSE.equals(this.next)) {
                    this.callback.beforeNext(this.rs);
                    this.next = this.rs.next();
                    this.callback.afterNext(this.rs, this.next);
                    if (!this.next.booleanValue()) continue;
                    this.nextFeature = this.readNextFeature();
                }
                if (!this.next.booleanValue()) {
                    this.callback.finish(this);
                }
            }
            catch (SQLException e) {
                this.callback.rowError(e);
                throw new RuntimeException(e);
            }
        }
        return this.next;
    }

    protected SimpleFeature readNextFeature() throws IOException {
        String fid;
        try {
            fid = this.dataStore.encodeFID(this.pkey, this.rs, this.offset);
            if (fid == null) {
                return null;
            }
            fid = this.featureType.getTypeName() + "." + fid;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine fid from primary key", e);
        }
        int attributeCount = this.featureType.getAttributeCount();
        int[] attributeRsIndex = this.buildAttributeRsIndex();
        for (int i = 0; i < attributeCount; ++i) {
            AttributeDescriptor type = this.featureType.getDescriptor(i);
            try {
                Class binding;
                Object converted;
                Object value = null;
                if (type instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)type;
                    try {
                        value = this.dataStore.getSQLDialect().decodeGeometryValue(gatt, this.rs, this.offset + attributeRsIndex[i], this.geometryFactory, this.cx, this.hints);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (value != null) {
                        Geometry geometry = (Geometry)value;
                        if (geometry.getUserData() == null) {
                            geometry.setUserData((Object)gatt.getCoordinateReferenceSystem());
                        }
                        try {
                            if (this.screenMap != null && this.screenMap.canSimplify(geometry.getEnvelopeInternal())) {
                                if (this.screenMap.checkAndSet(geometry.getEnvelopeInternal())) {
                                    this.builder.reset();
                                    return null;
                                }
                                value = this.screenMap.getSimplifiedShape(geometry);
                            }
                        }
                        catch (TransformException e) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "Failed to process screenmap checks, proceeding without", e);
                            }
                        }
                    }
                } else {
                    value = this.rs.getObject(this.offset + attributeRsIndex[i]);
                }
                if (value != null && (converted = Converters.convert(value, binding = type.getType().getBinding())) != null && converted != value) {
                    value = converted;
                    if (this.dataStore.getLogger().isLoggable(Level.FINER)) {
                        String msg = value + " is not of type " + binding.getName() + ", attempting conversion";
                        this.dataStore.getLogger().finer(msg);
                    }
                }
                this.builder.add(value);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.builder.buildFeature(fid);
        }
        catch (IllegalAttributeException e) {
            this.builder.reset();
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    protected void ensureNext() {
        if (this.next == null) {
            throw new IllegalStateException("Must call hasNext before calling next");
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.rs == null) {
            throw new IOException("reader already closed");
        }
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        try {
            this.ensureOpen();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more features in this reader, you should call hasNext() to check for feature availability");
            }
            if (this.nextFeature == null) {
                this.nextFeature = this.readNextFeature();
            }
            if (this.nextFeature == null && this.screenMap != null) {
                throw new IllegalStateException("Feature joining currently not supported along screenmap");
            }
            SimpleFeature simpleFeature = this.nextFeature;
            return simpleFeature;
        }
        finally {
            this.nextFeature = null;
            this.next = null;
        }
    }

    private int[] buildAttributeRsIndex() {
        LinkedHashSet<String> pkColumns = JDBCDataStore.getColumnNames(this.pkey);
        ArrayList<String> pkColumnsList = new ArrayList<String>(pkColumns);
        int[] indexes = new int[this.featureType.getAttributeCount()];
        int exposedPks = 0;
        for (int i = 0; i < indexes.length; ++i) {
            String attName = this.featureType.getDescriptor(i).getLocalName();
            if (pkColumns.contains(attName)) {
                indexes[i] = pkColumnsList.indexOf(attName) + 1;
                ++exposedPks;
                continue;
            }
            indexes[i] = i + pkColumns.size() - exposedPks + 1;
        }
        return indexes;
    }

    @Override
    public void close() throws IOException {
        if (this.dataStore != null) {
            this.dataStore.closeSafe(this.rs);
            this.dataStore.closeSafe(this.st);
            this.dataStore.releaseConnection(this.cx, this.featureSource.getState());
        }
        this.cleanup();
    }

    protected void cleanup() throws IOException {
        this.rs = null;
        this.st = null;
        this.dataStore = null;
        this.featureSource = null;
        this.featureType = null;
        this.geometryFactory = null;
        this.tx = null;
        this.hints = null;
        this.next = null;
        this.builder = null;
        this.tracer = null;
    }

    protected void finalize() throws Throwable {
        if (this.dataStore != null) {
            LOGGER.warning("There is code leaving feature readers/iterators open, this is leaking statements and connections!");
            if (TRACE_ENABLED.booleanValue()) {
                LOGGER.log(Level.WARNING, "The unclosed reader originated on this stack trace", this.tracer);
            }
            this.close();
        }
    }

    protected class ResultSetFeature
    implements SimpleFeature {
        ResultSet rs;
        Connection cx;
        PrimaryKey key;
        Object[] values;
        FeatureId fid;
        boolean[] dirty;
        boolean newFeature;
        HashMap<String, Integer> index;
        HashMap<Object, Object> userData = new HashMap();
        boolean exposePrimaryKeys;

        ResultSetFeature(ResultSet rs, Connection cx) throws SQLException, IOException {
            this.rs = rs;
            this.cx = cx;
            this.key = JDBCFeatureReader.this.dataStore.getPrimaryKey(JDBCFeatureReader.this.featureType);
            int count = JDBCFeatureReader.this.md.getColumnCount();
            JDBCFeatureReader.this.columnNames = new String[count];
            this.exposePrimaryKeys = JDBCFeatureReader.this.featureSource.getState().isExposePrimaryKeyColumns();
            block0: for (int i = 0; i < JDBCFeatureReader.this.md.getColumnCount(); ++i) {
                String columnName;
                JDBCFeatureReader.this.columnNames[i] = columnName = JDBCFeatureReader.this.md.getColumnName(i + 1);
                if (this.exposePrimaryKeys) continue;
                for (PrimaryKeyColumn col : this.key.getColumns()) {
                    if (!col.getName().equals(columnName)) continue;
                    --count;
                    continue block0;
                }
            }
            this.values = new Object[count];
            this.dirty = new boolean[this.values.length];
            this.index = new HashMap();
            int offset = 0;
            block2: for (int i = 0; i < JDBCFeatureReader.this.md.getColumnCount(); ++i) {
                if (!this.exposePrimaryKeys) {
                    for (PrimaryKeyColumn col : this.key.getColumns()) {
                        if (!col.getName().equals(JDBCFeatureReader.this.md.getColumnName(i + 1))) continue;
                        ++offset;
                        continue block2;
                    }
                }
                this.index.put(JDBCFeatureReader.this.md.getColumnName(i + 1), i - offset);
            }
        }

        public void init(String fid) {
            this.newFeature = fid == null;
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
                this.dirty[i] = false;
            }
            this.fid = SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)fid);
        }

        public void init() throws SQLException, IOException {
            this.init(JDBCFeatureReader.this.featureType.getTypeName() + "." + JDBCFeatureReader.this.dataStore.encodeFID(this.key, this.rs, JDBCFeatureReader.this.offset));
        }

        public SimpleFeatureType getFeatureType() {
            return JDBCFeatureReader.this.featureType;
        }

        public SimpleFeatureType getType() {
            return JDBCFeatureReader.this.featureType;
        }

        public FeatureId getIdentifier() {
            return this.fid;
        }

        public String getID() {
            return this.fid.getID();
        }

        public void setID(String id) {
            ((FeatureIdImpl)this.fid).setID(id);
        }

        public Object getAttribute(String name) {
            return this.getAttribute(this.index.get(name));
        }

        public Object getAttribute(Name name) {
            return this.getAttribute(name.getLocalPart());
        }

        public Object getAttribute(int index) throws IndexOutOfBoundsException {
            return this.getAttributeInternal(index, this.mapToResultSetIndex(index));
        }

        private int mapToResultSetIndex(int index) {
            int rsindex = index;
            block0: for (int i = 0; i <= index; ++i) {
                if (this.exposePrimaryKeys) continue;
                for (PrimaryKeyColumn col : this.key.getColumns()) {
                    if (!col.getName().equals(JDBCFeatureReader.this.columnNames[i])) continue;
                    ++rsindex;
                    continue block0;
                }
            }
            return ++rsindex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAttributeInternal(int index, int rsindex) {
            if (!this.newFeature && this.values[index] == null && !this.dirty[index]) {
                ResultSetFeature resultSetFeature = this;
                synchronized (resultSetFeature) {
                    try {
                        if (!this.newFeature && this.values[index] == null && !this.dirty[index]) {
                            AttributeDescriptor att = JDBCFeatureReader.this.featureType.getDescriptor(index);
                            if (att instanceof GeometryDescriptor) {
                                GeometryDescriptor gatt = (GeometryDescriptor)att;
                                this.values[index] = JDBCFeatureReader.this.dataStore.getSQLDialect().decodeGeometryValue(gatt, this.rs, rsindex, JDBCFeatureReader.this.dataStore.getGeometryFactory(), this.cx, JDBCFeatureReader.this.hints);
                            } else {
                                this.values[index] = this.rs.getObject(rsindex);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SQLException e) {
                        this.values[index] = null;
                    }
                }
            }
            return this.values[index];
        }

        public void setAttribute(String name, Object value) {
            if (JDBCFeatureReader.this.dataStore.getLogger().isLoggable(Level.FINE)) {
                JDBCFeatureReader.this.dataStore.getLogger().fine("Setting " + name + " to " + value);
            }
            int i = this.index.get(name);
            this.setAttribute(i, value);
        }

        public void setAttribute(Name name, Object value) {
            this.setAttribute(name.getLocalPart(), value);
        }

        public void setAttribute(int index, Object value) throws IndexOutOfBoundsException {
            if (JDBCFeatureReader.this.dataStore.getLogger().isLoggable(Level.FINE)) {
                JDBCFeatureReader.this.dataStore.getLogger().fine("Setting " + index + " to " + value);
            }
            this.values[index] = value;
            this.dirty[index] = true;
        }

        public void setAttributes(List<Object> values) {
            for (int i = 0; i < values.size(); ++i) {
                this.setAttribute(i, values.get(i));
            }
        }

        public int getAttributeCount() {
            return this.values.length;
        }

        public boolean isDirty(int index) {
            return this.dirty[index];
        }

        public boolean isDirrty(String name) {
            return this.isDirty(name);
        }

        public boolean isDirty(String name) {
            return this.isDirty(this.index.get(name));
        }

        public void close() {
            this.rs = null;
            this.cx = null;
            JDBCFeatureReader.this.columnNames = null;
        }

        public List<Object> getAttributes() {
            return Arrays.asList(this.values);
        }

        public Object getDefaultGeometry() {
            GeometryDescriptor defaultGeometry = JDBCFeatureReader.this.featureType.getGeometryDescriptor();
            return defaultGeometry != null ? this.getAttribute(defaultGeometry.getName()) : null;
        }

        public void setAttributes(Object[] object) {
            if (object == null) {
                throw new NullPointerException("Attributes array is null");
            }
            if (object.length != this.values.length) {
                throw new IllegalArgumentException("The passed array has wrong size: passed_size=" + object.length + " values_size" + this.values.length);
            }
            for (int i = 0; i < object.length; ++i) {
                this.setAttribute(i, object[i]);
            }
        }

        public void setDefaultGeometry(Object defaultGeometry) {
            GeometryDescriptor descriptor = JDBCFeatureReader.this.featureType.getGeometryDescriptor();
            this.setAttribute(descriptor.getName(), defaultGeometry);
        }

        public BoundingBox getBounds() {
            Object obj = this.getDefaultGeometry();
            if (obj instanceof Geometry) {
                Geometry geometry = (Geometry)obj;
                return ReferencedEnvelope.create(geometry.getEnvelopeInternal(), JDBCFeatureReader.this.featureType.getCoordinateReferenceSystem());
            }
            return ReferencedEnvelope.create(JDBCFeatureReader.this.featureType.getCoordinateReferenceSystem());
        }

        public GeometryAttribute getDefaultGeometryProperty() {
            GeometryDescriptor geometryDescriptor = JDBCFeatureReader.this.featureType.getGeometryDescriptor();
            GeometryAttributeImpl geometryAttribute = null;
            if (geometryDescriptor != null) {
                Object defaultGeometry = this.getDefaultGeometry();
                geometryAttribute = new GeometryAttributeImpl(defaultGeometry, geometryDescriptor, null);
            }
            return geometryAttribute;
        }

        public void setDefaultGeometryProperty(GeometryAttribute defaultGeometry) {
            if (defaultGeometry != null) {
                this.setDefaultGeometry(defaultGeometry.getValue());
            } else {
                this.setDefaultGeometry(null);
            }
        }

        public Collection<Property> getProperties() {
            throw new UnsupportedOperationException("Use getAttributes()");
        }

        public Collection<Property> getProperties(Name name) {
            throw new UnsupportedOperationException("Use getAttributes()");
        }

        public Collection<Property> getProperties(String name) {
            throw new UnsupportedOperationException("Use getAttributes()");
        }

        public Property getProperty(Name name) {
            throw new UnsupportedOperationException("Use getAttribute()");
        }

        public Property getProperty(String name) {
            throw new UnsupportedOperationException("Use getAttribute()");
        }

        public Collection<? extends Property> getValue() {
            return this.getProperties();
        }

        public void setValue(Collection<Property> value) {
            int i = 0;
            for (Property p : value) {
                this.values[i] = p.getValue();
            }
        }

        public AttributeDescriptor getDescriptor() {
            return new AttributeDescriptorImpl((AttributeType)JDBCFeatureReader.this.featureType, JDBCFeatureReader.this.featureType.getName(), 0, Integer.MAX_VALUE, true, null);
        }

        public Name getName() {
            return JDBCFeatureReader.this.featureType.getName();
        }

        public Map<Object, Object> getUserData() {
            return this.userData;
        }

        public boolean isNillable() {
            return true;
        }

        public void setValue(Object value) {
            this.setValue((Collection)value);
        }

        public void validate() {
            for (int i = 0; i < this.values.length; ++i) {
                AttributeDescriptor descriptor = this.getType().getDescriptor(i);
                Types.validate((AttributeDescriptor)descriptor, (Object)this.values[i]);
            }
        }
    }

    @FunctionalInterface
    static interface QueryRunner {
        public ResultSet run() throws Exception;
    }
}

