/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.jdbc.EscapeSql;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;

public class VirtualTable
implements Serializable {
    private static final Hints.Key KEEP_WHERE_CLAUSE_PLACE_HOLDER_KEY = new Hints.Key(Boolean.class);
    public static String WHERE_CLAUSE_PLACE_HOLDER = ":where_clause:";
    public static int WHERE_CLAUSE_PLACE_HOLDER_LENGTH = 14;
    static final Logger LOGGER = Logging.getLogger(VirtualTable.class);
    String name;
    String sql;
    List<String> primaryKeyColumns = new CopyOnWriteArrayList<String>();
    Map<String, Class<? extends Geometry>> geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>();
    Map<String, Integer> nativeSrids = new ConcurrentHashMap<String, Integer>();
    Map<String, Integer> dimensions = new ConcurrentHashMap<String, Integer>();
    Map<String, VirtualTableParameter> parameters = new ConcurrentHashMap<String, VirtualTableParameter>();
    boolean escapeSql = false;

    public static Hints setKeepWhereClausePlaceHolderHint(Query query) {
        Filter filter = query.getFilter();
        return VirtualTable.setKeepWhereClausePlaceHolderHint(query.getHints(), filter != null && filter != Filter.INCLUDE);
    }

    public static Hints setKeepWhereClausePlaceHolderHint(Hints hints, boolean keepWhereClausePlaceHolder) {
        if (hints == null) {
            hints = new Hints();
        }
        hints.put((Object)KEEP_WHERE_CLAUSE_PLACE_HOLDER_KEY, (Object)keepWhereClausePlaceHolder);
        return hints;
    }

    public VirtualTable(String name, String sql) {
        this.name = name;
        if (!sql.endsWith("\n") && !sql.endsWith("\r")) {
            sql = sql + "\n";
        }
        this.sql = sql;
    }

    public VirtualTable(String name, String sql, boolean escapeSql) {
        this(name, sql);
        this.escapeSql = escapeSql;
    }

    public VirtualTable(String name, VirtualTable other) {
        this(name, other.sql);
        this.geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>(other.geometryTypes);
        this.nativeSrids = new ConcurrentHashMap<String, Integer>(other.nativeSrids);
        this.dimensions = new ConcurrentHashMap<String, Integer>(other.dimensions);
        this.parameters = new ConcurrentHashMap<String, VirtualTableParameter>(other.parameters);
        this.primaryKeyColumns = new ArrayList<String>(other.primaryKeyColumns);
        this.escapeSql = other.escapeSql;
    }

    public VirtualTable(VirtualTable other) {
        this(other.name, other.sql);
        this.geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>(other.geometryTypes);
        this.nativeSrids = new ConcurrentHashMap<String, Integer>(other.nativeSrids);
        this.dimensions = new ConcurrentHashMap<String, Integer>(other.dimensions);
        this.parameters = new ConcurrentHashMap<String, VirtualTableParameter>(other.parameters);
        this.primaryKeyColumns = new ArrayList<String>(other.primaryKeyColumns);
        this.escapeSql = other.escapeSql;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
        this.primaryKeyColumns.clear();
        if (primaryKeyColumns != null) {
            this.primaryKeyColumns.addAll(primaryKeyColumns);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }

    public String expandParameters(Hints hints) throws SQLException {
        String result = this.sql;
        if (!VirtualTable.keepWhereClausePlaceHolder(hints)) {
            result = VirtualTable.removeWhereClausePlaceHolder(result);
        }
        if (this.parameters.size() == 0) {
            return result;
        }
        Map values = null;
        if (hints != null) {
            values = (Map)hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        }
        if (values == null) {
            values = Collections.emptyMap();
        }
        for (VirtualTableParameter param : this.parameters.values()) {
            String value = (String)values.get(param.getName());
            if (value == null) {
                value = param.getDefaultValue();
                if (value == null) {
                    value = "";
                }
            } else if (param.getValidator() != null) {
                try {
                    param.getValidator().validate(value);
                    if (this.escapeSql) {
                        value = EscapeSql.escapeSql(value);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.SEVERE, "Invalid value for parameter " + param.getName(), e);
                    throw new SQLException("Invalid value for parameter " + param.getName());
                }
            }
            result = result.replace("%" + param.getName() + "%", value);
        }
        return result;
    }

    public void addGeometryMetadatata(String geometry, Class<? extends Geometry> binding, int nativeSrid) {
        this.geometryTypes.put(geometry, binding);
        this.nativeSrids.put(geometry, nativeSrid);
    }

    public void addGeometryMetadatata(String geometry, Class<? extends Geometry> binding, int nativeSrid, int dimension) {
        this.geometryTypes.put(geometry, binding);
        this.nativeSrids.put(geometry, nativeSrid);
        this.dimensions.put(geometry, dimension);
    }

    public void addParameter(VirtualTableParameter param) {
        this.parameters.put(param.getName(), param);
    }

    public void removeParameter(String paramName) {
        this.parameters.remove(paramName);
    }

    public Collection<String> getParameterNames() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    public VirtualTableParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public Class<? extends Geometry> getGeometryType(String geometryName) {
        return this.geometryTypes.get(geometryName);
    }

    public Set<String> getGeometries() {
        return this.geometryTypes.keySet();
    }

    public int getNativeSrid(String geometryName) {
        Integer srid = this.nativeSrids.get(geometryName);
        if (srid == null) {
            srid = -1;
        }
        return srid;
    }

    public int getDimension(String geometryName) {
        Integer dimension = this.dimensions.get(geometryName);
        if (dimension == null) {
            dimension = 2;
        }
        return dimension;
    }

    public boolean isEscapeSql() {
        return this.escapeSql;
    }

    public void setEscapeSql(boolean escapeSql) {
        this.escapeSql = escapeSql;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geometryTypes == null ? 0 : this.geometryTypes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nativeSrids == null ? 0 : this.nativeSrids.hashCode());
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.primaryKeyColumns == null ? 0 : this.primaryKeyColumns.hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + (this.escapeSql ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualTable other = (VirtualTable)obj;
        if (this.geometryTypes == null ? other.geometryTypes != null : !this.geometryTypes.equals(other.geometryTypes)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nativeSrids == null ? other.nativeSrids != null : !this.nativeSrids.equals(other.nativeSrids)) {
            return false;
        }
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.primaryKeyColumns == null ? other.primaryKeyColumns != null : !this.primaryKeyColumns.equals(other.primaryKeyColumns)) {
            return false;
        }
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        return this.escapeSql == other.escapeSql;
    }

    public String toString() {
        return "VirtualTable [name=" + this.name + ", sql=" + this.sql + "]";
    }

    private static boolean keepWhereClausePlaceHolder(Hints hints) {
        if (hints == null) {
            return false;
        }
        Object value = hints.get((Object)KEEP_WHERE_CLAUSE_PLACE_HOLDER_KEY);
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    private static String removeWhereClausePlaceHolder(String sql) {
        int whereClauseIndex = sql.indexOf(WHERE_CLAUSE_PLACE_HOLDER);
        if (whereClauseIndex < 0) {
            return sql;
        }
        if (whereClauseIndex != sql.lastIndexOf(WHERE_CLAUSE_PLACE_HOLDER)) {
            throw new RuntimeException(String.format("SQL contains multiple where clause placeholders: %s.", sql));
        }
        return sql.replace(WHERE_CLAUSE_PLACE_HOLDER, "");
    }
}

