/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

public abstract class WarpOpImage
extends javax.media.jai.WarpOpImage {
    protected static final BorderExtender ZERO_EXTENDER = BorderExtender.createInstance((int)0);
    protected static final int TILE_EXTENDER = 1;
    protected static final boolean ARRAY_CALC = true;
    protected static final boolean TILE_CACHED = true;
    protected final ROI roi;
    protected final boolean hasROI;
    protected final boolean hasNoData;
    protected final boolean caseA;
    protected final boolean caseB;
    protected final boolean caseC;
    protected Range noDataRange;
    protected boolean extended;
    private RenderingHints hints;
    protected int leftPad;
    protected int rightPad;
    protected int topPad;
    protected int bottomPad;
    protected volatile PlanarImage roiImage;
    protected Rectangle roiBounds;

    public WarpOpImage(RenderedImage source, ImageLayout layout, Map<?, ?> configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, Warp warp, double[] backgroundValues, ROI roi, Range noData) {
        super(source, layout, configuration, cobbleSources, extender, interp, warp, WarpOpImage.prepareBackground(source, layout, interp, backgroundValues));
        this.roi = roi;
        boolean bl = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roiBounds = roi.getBounds();
        }
        boolean bl2 = this.hasNoData = interp instanceof InterpolationNoData && ((InterpolationNoData)interp).getNoDataRange() != null || noData != null;
        if (this.hasNoData) {
            if (interp instanceof InterpolationNoData) {
                this.noDataRange = ((InterpolationNoData)interp).getNoDataRange();
            }
            if (this.noDataRange == null) {
                this.noDataRange = noData;
            }
        } else {
            this.noDataRange = null;
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
        boolean bl3 = this.extended = extender != null;
        if (configuration instanceof RenderingHints) {
            this.hints = (RenderingHints)configuration;
        }
        this.leftPad = 0;
        this.rightPad = 0;
        this.topPad = 0;
        this.bottomPad = 0;
    }

    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle destRect = new Rectangle(org.x, org.y, this.tileWidth, this.tileHeight).intersection(this.computableBounds);
        if (destRect.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.backgroundValues);
            }
            return dest;
        }
        PlanarImage source = this.getSourceImage(0);
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        if (!srcRect.intersects(source.getBounds())) {
            if (this.setBackground) {
                ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.backgroundValues);
            }
            return dest;
        }
        if (this.roi != null && !this.roi.intersects(srcRect)) {
            if (this.setBackground) {
                ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.backgroundValues);
            }
            return dest;
        }
        if (this.cobbleSources) {
            throw new UnsupportedOperationException();
        }
        PlanarImage[] srcs = new PlanarImage[]{source};
        this.computeRect(srcs, dest, destRect);
        return dest;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - (double)this.leftPad, srcRectExpanded.getMinY() - (double)this.topPad, srcRectExpanded.getWidth() + (double)this.rightPad + (double)this.leftPad, srcRectExpanded.getHeight() + (double)this.bottomPad + (double)this.topPad);
            roiTile = this.roi.intersect((ROI)new ROIGeometry(srcRectExpanded));
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (dst.getDataType()) {
                case 0: {
                    this.computeRectByte(sources[0], dst, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.computeRectUShort(sources[0], dst, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.computeRectShort(sources[0], dst, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.computeRectInt(sources[0], dst, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.computeRectFloat(sources[0], dst, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.computeRectDouble(sources[0], dst, roiIter, roiContainsTile);
                }
            }
            if (dst.isDataCopy()) {
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        } else if (this.setBackground) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.backgroundValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            WarpOpImage warpOpImage = this;
            synchronized (warpOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }

    protected abstract void computeRectByte(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void computeRectUShort(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void computeRectShort(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void computeRectInt(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void computeRectFloat(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void computeRectDouble(PlanarImage var1, RasterAccessor var2, RandomIter var3, boolean var4);

    public static double[] prepareBackground(RenderedImage source, ImageLayout layout, Interpolation interp, double[] backgroundValues) {
        if (interp instanceof InterpolationNoData) {
            SampleModel sm = layout != null ? layout.getSampleModel(source) : source.getSampleModel();
            int numBands = sm.getNumBands();
            double[] destinationNoData = new double[numBands];
            Arrays.fill(destinationNoData, ((InterpolationNoData)interp).getDestinationNoData());
            return destinationNoData;
        }
        if (backgroundValues != null) {
            return backgroundValues;
        }
        return new double[]{0.0};
    }

    public static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    public static final int round(float f) {
        return f >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f);
    }

    protected RandomIter getRandomIterator(PlanarImage src, BorderExtender extender) {
        return this.getRandomIterator(src, 0, 1, 0, 1, extender);
    }

    protected RandomIter getRandomIterator(PlanarImage src, int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender extender) {
        RandomIter iterSource;
        if (this.extended) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(src);
            pb.add(leftPad);
            pb.add(rightPad);
            pb.add(topPad);
            pb.add(bottomPad);
            pb.add(extender);
            pb.add(this.noDataRange);
            pb.add(this.backgroundValues != null ? this.backgroundValues[0] : 0.0);
            RenderedOp op = JAI.create((String)"Border", (ParameterBlock)pb, (RenderingHints)this.hints);
            iterSource = RandomIterFactory.create((RenderedImage)op, (Rectangle)op.getBounds(), (boolean)true, (boolean)true);
        } else {
            iterSource = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        }
        return iterSource;
    }
}

