/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.util.HashMap;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import org.geotools.measure.Units;
import org.geotools.referencing.wkt.GeoToolsUnitFormat;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.unit.TransformedUnit;

public class DefaultUnitParser
extends GeoToolsUnitFormat.BaseGT2Format {
    private static final DefaultUnitParser UNITPARSER = new DefaultUnitParser();
    protected HashMap<UnitWrapper, Unit<?>> unitWrapperToUnitMap = new HashMap();

    public static DefaultUnitParser getInstance() {
        return UNITPARSER;
    }

    public static DefaultUnitParser getInstance(SimpleUnitFormat.Flavor flavour) {
        return UNITPARSER;
    }

    DefaultUnitParser() {
        this.initUnits();
        DefaultUnitParser.esriLabelsAndAliases(this);
        DefaultUnitParser.epsgLabelsAndAliases(this);
    }

    @Override
    protected void addUnit(Unit<?> unit) {
        this.unitWrapperToUnitMap.put(new UnitWrapper(unit), unit);
    }

    public <Q extends Quantity<Q>> Unit<Q> getEquivalentUnit(Unit<Q> unit) {
        return this.unitWrapperToUnitMap.getOrDefault(new UnitWrapper(unit), unit);
    }

    static class UnitWrapper {
        private Unit<?> unit;

        public UnitWrapper(Unit<?> unit) {
            this.unit = unit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnitWrapper) {
                return Units.equals(this.unit, ((UnitWrapper)obj).getUnit());
            }
            return false;
        }

        public Unit<?> getUnit() {
            return this.unit;
        }

        public int hashCode() {
            if (this.unit instanceof TransformedUnit) {
                Unit systemUnit = this.unit.getSystemUnit();
                try {
                    float factor1 = (float)this.unit.getConverterToAny(systemUnit).convert(1.0);
                    return Objects.hash(systemUnit, Float.floatToIntBits(factor1));
                }
                catch (IncommensurableException | UnconvertibleException throwable) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.unit.hashCode();
        }

        public String toString() {
            return this.unit.toString();
        }
    }
}

