/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collection;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.GeometryAttribute;
import org.opengis.filter.identity.FeatureId;

public class ComplexAttributeConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ComplexAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof ComplexAttribute) {
                        Collection valueMap = ((ComplexAttribute)source).getValue();
                        if (valueMap.isEmpty() || valueMap.size() > 1) {
                            return null;
                        }
                        source = valueMap.iterator().next();
                        if (AttributeImpl.class.equals(source.getClass())) {
                            return Converters.convert(((Attribute)source).getValue(), target);
                        }
                    }
                    return null;
                }
            };
        }
        if (GeometryAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof GeometryAttribute) {
                        return Converters.convert(((GeometryAttribute)source).getValue(), target);
                    }
                    return null;
                }
            };
        }
        if (FeatureId.class.isAssignableFrom(target) && String.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) {
                    if (source != null) {
                        return new FeatureIdImpl((String)source);
                    }
                    return null;
                }
            };
        }
        if (Attribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) {
                    if (source instanceof Attribute) {
                        Attribute attribute = (Attribute)source;
                        Object value = attribute.getValue();
                        return Converters.convert(value, target);
                    }
                    return null;
                }
            };
        }
        if (Collection.class.isAssignableFrom(source) && target == String.class) {
            return new Converter(){

                public Object convert(Object source, Class target) {
                    if (!ComplexAttributeConverterFactory.this.isCollectionOf(source, Attribute.class)) {
                        return null;
                    }
                    StringBuilder builder = new StringBuilder();
                    Collection collection = (Collection)source;
                    for (Object element : collection) {
                        if (element == null) {
                            builder.append("NULL, ");
                            continue;
                        }
                        builder.append(Converters.convert(element, String.class));
                        builder.append(", ");
                    }
                    if (builder.length() == 0) {
                        return "";
                    }
                    builder.delete(builder.length() - 2, builder.length());
                    return builder.toString();
                }
            };
        }
        return null;
    }

    private boolean isCollectionOf(Object source, Class<?> expected) {
        if (!(source instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)source;
        for (Object element : collection) {
            if (element != null && expected.isAssignableFrom(element.getClass())) continue;
            return false;
        }
        return true;
    }
}

