/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Position;
import org.geolatte.geom.PositionEquality;

abstract class AbstractPositionEquality
implements PositionEquality {
    AbstractPositionEquality() {
    }

    @Override
    public <P extends Position> boolean equals(P first, P second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        return this.equals(first.toArray(null), second.toArray(null));
    }

    @Override
    public <P extends Position> boolean equals2D(P first, P second) {
        if (first == second) {
            return true;
        }
        return first != null && second != null && this.internalEquals(first.toArray(null), 2, second.toArray(null), 2);
    }

    @Override
    public <P extends Position> boolean equals(double[] first, double[] second) {
        return this.internalEquals(first, first.length, second, second.length);
    }

    private boolean internalEquals(double[] first, int l1, double[] second, int l2) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("Null objects not allowed here.");
        }
        if (first.length > 0 && first.length < l1 || second.length > 0 && second.length < l2) {
            throw new IllegalArgumentException("Position arrays are inconsistent with passed coordinate systems.");
        }
        if (l1 != l2) {
            return false;
        }
        if (first.length == 0 && second.length == 0) {
            return true;
        }
        if (first.length == 0 || second.length == 0) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (this.equals(first[i], second[i])) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean equals(double var1, double var3);
}

