/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.entity;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.entity.Bericht;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BrkBericht
extends Bericht {
    private final String soort = "brk";
    private boolean xpathEvaluated = false;
    private static final Log log = LogFactory.getLog(BrkBericht.class);

    public BrkBericht(String brXml) {
        super(brXml);
    }

    public void setVervallenInfo(String objectRef, Date datum) {
        this.objectRef = objectRef;
        this.datum = datum;
        this.xpathEvaluated = true;
    }

    private void evaluateXPath() {
        if (this.xpathEvaluated) {
            return;
        }
        this.xpathEvaluated = true;
        if (this.objectRef != null && this.datum != null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(this.getBrXml())));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/KadastraalObjectSnapshot/*[local-name()= 'Perceel' or local-name()='Appartementsrecht']/identificatie/namespace/text()");
            this.objectRef = expr.evaluate(doc);
            expr = xpath.compile("/KadastraalObjectSnapshot/*[local-name()= 'Perceel' or local-name()='Appartementsrecht']/identificatie/lokaalId/text()");
            this.objectRef = this.objectRef + ":" + expr.evaluate(doc);
            expr = xpath.compile("/KadastraalObjectSnapshot/*[local-name()= 'toestandsdatum' or local-name()='toestandsdatum']/text()");
            this.setDatumAsString(expr.evaluate(doc));
        }
        catch (Exception e) {
            log.error((Object)"Error while getting brk referentie", (Throwable)e);
        }
    }

    public void setDatumAsString(String d) {
        if (d == null || d.isEmpty()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.datum = sdf.parse(d);
        }
        catch (ParseException pe) {
            log.error((Object)("Error while parsing date: " + this.datum), (Throwable)pe);
        }
    }

    @Override
    public String getObjectRef() {
        this.evaluateXPath();
        return this.objectRef;
    }

    @Override
    public Date getDatum() {
        this.evaluateXPath();
        return this.datum;
    }

    public String getRestoredFileName(Date bestanddatum, Integer volgordenummer) {
        try {
            SimpleDateFormat output = new SimpleDateFormat("yyyyMMdd");
            String prefix = "BKE-MUTBX01";
            String brkdatum = output.format(bestanddatum);
            String basePath = "/KadastraalObjectSnapshot/*[local-name()= 'Perceel' or local-name()='Appartementsrecht']/kadastraleAanduiding/";
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(this.getBrXml())));
            if (this.getBrXml().contains("<empty/>") && StringUtils.isNotBlank((CharSequence)this.getBrOrgineelXml())) {
                basePath = "/Mutatie/kadastraalObject/AanduidingKadastraalObject/kadastraleAanduiding/";
                doc = builder.parse(new InputSource(new StringReader(this.getBrOrgineelXml())));
            }
            XPathExpression expr = xpath.compile(basePath + "AKRKadastraleGemeenteCode/waarde/text()");
            String kadGemCode = expr.evaluate(doc);
            expr = xpath.compile(basePath + "sectie/text()");
            String sectie = expr.evaluate(doc);
            expr = xpath.compile(basePath + "perceelnummer/text()");
            String perceelnummer = expr.evaluate(doc);
            expr = xpath.compile(basePath + "appartementsrechtVolgnummer/text()");
            String appartementsrechtVolgnummer = expr.evaluate(doc);
            if (StringUtils.isNotBlank((CharSequence)appartementsrechtVolgnummer)) {
                appartementsrechtVolgnummer = "A" + appartementsrechtVolgnummer;
            }
            String aanduiding = kadGemCode + sectie + perceelnummer + appartementsrechtVolgnummer;
            log.debug((Object)("gevonden aanduiding voor herstelde bestandsnaam: " + aanduiding));
            String filename = "bestandsnaam kon niet worden hersteld";
            if (StringUtils.isNotBlank((CharSequence)aanduiding)) {
                filename = prefix + "-" + aanduiding + "-" + brkdatum + "-" + volgordenummer.toString() + ".zip";
            }
            return filename;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            log.error((Object)"Cannot create filename from xml: ", (Throwable)ex);
            return "";
        }
    }
}

