/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.curve;

import org.geolatte.geom.C2D;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MortonContext<P extends C2D> {
    private static final String ERR_MSG_MAX_DEPTH = "Max. depth is limited to 31";
    private static final String ERR_MSG_NULL = "No Null arguments allowed.";
    private final int depth;
    private final Envelope<P> extent;
    private final int numOfDivisionsAlongAxis;
    private final double leafWidth;
    private final double leafHeight;

    public MortonContext(Envelope<P> extent, int depth) {
        if (extent == null) {
            throw new IllegalArgumentException(ERR_MSG_NULL);
        }
        if (depth >= 32) {
            throw new IllegalArgumentException(ERR_MSG_MAX_DEPTH);
        }
        this.depth = depth;
        this.extent = extent;
        this.numOfDivisionsAlongAxis = (int)Math.pow(2.0, depth);
        this.leafWidth = extent.extentAlongDimension(0) / (double)this.numOfDivisionsAlongAxis;
        this.leafHeight = extent.extentAlongDimension(1) / (double)this.numOfDivisionsAlongAxis;
    }

    public double getMaxX() {
        return ((C2D)this.extent.upperRight()).getCoordinate(0);
    }

    public double getMaxY() {
        return ((C2D)this.extent.upperRight()).getCoordinate(1);
    }

    public double getMinX() {
        return ((C2D)this.extent.lowerLeft()).getCoordinate(0);
    }

    public double getMinY() {
        return ((C2D)this.extent.lowerLeft()).getCoordinate(1);
    }

    public int getDepth() {
        return this.depth;
    }

    public CoordinateReferenceSystem<?> getCoordinateReferenceSystem() {
        return this.extent.getCoordinateReferenceSystem();
    }

    int getNumberOfDivisionsAlongAxis() {
        return this.numOfDivisionsAlongAxis;
    }

    double getLeafWidth() {
        return this.leafWidth;
    }

    double getLeafHeight() {
        return this.leafHeight;
    }

    public boolean extentContains(P pos) {
        return this.extent.contains(pos);
    }

    public boolean extentContains(Envelope<P> envelope) {
        return this.extent.contains(envelope);
    }

    public Envelope<P> getExtent() {
        return this.extent;
    }
}

