/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.sqlserver.reader.Figure;
import org.geotools.data.sqlserver.reader.Shape;
import org.geotools.data.sqlserver.reader.SqlServerBinary;
import org.geotools.data.sqlserver.reader.SqlServerBinaryParseException;
import org.geotools.data.sqlserver.reader.Type;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;

public class SqlServerBinaryReader {
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private GeometryFactory gf = new GeometryFactory();
    private SqlServerBinary binary;

    public SqlServerBinaryReader() {
        this.gf = new GeometryFactory();
    }

    public SqlServerBinaryReader(GeometryFactory gf) {
        this.gf = gf;
    }

    public Geometry read(byte[] bytes) throws IOException {
        this.binary = new SqlServerBinary();
        return this.read((InStream)new ByteArrayInStream(bytes));
    }

    public Geometry read(InStream is) throws IOException {
        this.parse(is);
        this.readCoordinateSequences();
        Type type = this.getTypeFromBinary();
        Geometry geometry = this.decode(0, type);
        geometry.setSRID(this.binary.getSrid());
        return geometry;
    }

    private Geometry decode(int shapeIndex, Type type) throws SqlServerBinaryParseException {
        switch (type) {
            case GEOMETRYCOLLECTION: {
                return this.decodeGeometryCollection(shapeIndex);
            }
            case POINT: {
                return this.decodePoint(shapeIndex);
            }
            case LINESTRING: {
                return this.decodeLinestring(shapeIndex);
            }
            case POLYGON: {
                return this.decodePolygon(shapeIndex);
            }
            case MULTILINESTRING: {
                return this.decodeMultiLinestring(shapeIndex);
            }
            case MULTIPOINT: {
                return this.decodeMultiPoint(shapeIndex);
            }
            case MULTIPOLYGON: {
                return this.decodeMultiPolygon(shapeIndex);
            }
        }
        throw new SqlServerBinaryParseException("Geometry type unsupported " + (Object)((Object)type));
    }

    private Geometry decodeMultiPolygon(int shapeIndex) {
        ArrayList<Geometry> polygons = new ArrayList<Geometry>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            polygons.add(this.decodePolygon(i));
        }
        return this.gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    private Geometry decodeMultiPoint(int shapeIndex) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            points.add(this.gf.createPoint(this.binary.getSequence(this.binary.getShape(i).getFigureOffset())));
        }
        return this.gf.createMultiPoint(points.toArray(new Point[points.size()]));
    }

    private Geometry decodeMultiLinestring(int shapeIndex) {
        ArrayList<LineString> linestrings = new ArrayList<LineString>();
        for (int i = shapeIndex; i < this.binary.getShapes().length; ++i) {
            if (this.binary.getShape(i).getParentOffset() != shapeIndex) continue;
            linestrings.add(this.gf.createLineString(this.binary.getSequence(this.binary.getShape(i).getFigureOffset())));
        }
        return this.gf.createMultiLineString(linestrings.toArray(new LineString[linestrings.size()]));
    }

    private Geometry decodePolygon(int shapeIndex) {
        Shape shape = this.binary.getShape(shapeIndex);
        int figureOffset = shape.getFigureOffset();
        int figureStopIndex = this.binary.getFigures().length - 1;
        if (shapeIndex + 1 < this.binary.getShapes().length) {
            Shape nextShape = this.binary.getShape(shapeIndex + 1);
            figureStopIndex = nextShape.getFigureOffset() - 1;
        }
        ArrayList<LinearRing> linearRings = new ArrayList<LinearRing>();
        if (figureOffset <= -1) {
            return this.gf.createPolygon(new Coordinate[0]);
        }
        for (int i = figureOffset; i <= figureStopIndex; ++i) {
            CoordinateSequence sequence = this.binary.getSequence(i);
            linearRings.add(this.gf.createLinearRing(sequence));
        }
        LinearRing outerShell = (LinearRing)linearRings.remove(0);
        LinearRing[] holes = linearRings.toArray(new LinearRing[linearRings.size()]);
        return this.gf.createPolygon(outerShell, holes);
    }

    private Geometry decodeLinestring(int shapeIndex) {
        Shape shape = this.binary.getShape(shapeIndex);
        CoordinateSequence sequence = this.binary.getSequence(shape.getFigureOffset());
        return this.gf.createLineString(sequence);
    }

    private Geometry decodePoint(int shapeIndex) {
        Coordinate coordinate;
        Shape shape = this.binary.getShapes()[shapeIndex];
        if (this.binary.isSinglePoint()) {
            coordinate = this.binary.getCoordinates()[0];
        } else if (shape.getParentOffset() != -1) {
            Figure figure = this.binary.getFigure(shape.getFigureOffset());
            coordinate = this.binary.getCoordinates()[figure.getPointOffset()];
        } else {
            coordinate = null;
        }
        return this.gf.createPoint(coordinate);
    }

    private Geometry decodeGeometryCollection(int shapeIndex) throws SqlServerBinaryParseException {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = shapeIndex + 1; i < this.binary.getShapes().length; ++i) {
            Shape subShape = this.binary.getShapes()[i];
            if (subShape.getParentOffset() != shapeIndex) continue;
            geometries.add(this.decode(i, subShape.getType()));
        }
        return this.gf.buildGeometry(geometries);
    }

    private Type getTypeFromBinary() {
        if (this.binary.isSinglePoint()) {
            return Type.POINT;
        }
        if (this.binary.hasSingleLineSegment()) {
            return Type.LINESTRING;
        }
        return this.binary.getShapes()[0].getType();
    }

    private void readCoordinateSequences() {
        Figure[] figures = this.binary.getFigures();
        CoordinateSequence[] sequences = new CoordinateSequence[figures.length];
        for (int i = 0; i < figures.length; ++i) {
            int figurePointOffset = figures[i].getPointOffset();
            int nextPointOffset = figures.length >= i + 2 ? figures[i + 1].getPointOffset() : this.binary.getCoordinates().length;
            Coordinate[] coordinates = Arrays.copyOfRange(this.binary.getCoordinates(), figurePointOffset, nextPointOffset);
            int attribute = figures[i].getAttribute();
            if (!(attribute != 0 && attribute != 2 || coordinates[0].equals((Object)coordinates[coordinates.length - 1]))) {
                coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
                coordinates[coordinates.length - 1] = coordinates[0];
            }
            sequences[i] = this.gf.getCoordinateSequenceFactory().create(coordinates);
        }
        this.binary.setSequences(sequences);
    }

    private void parse(InStream is) throws IOException {
        this.dis.setInStream(is);
        this.dis.setOrder(2);
        this.binary.setSrid(this.dis.readInt());
        byte version = this.dis.readByte();
        if (version != 1) {
            throw new SqlServerBinaryParseException("Unsupported version (only supports version 1): " + version);
        }
        this.binary.setSerializationProperties(this.dis.readByte());
        this.readNumberOfPoints();
        this.readCoordinates();
        this.readZValues();
        this.readMValues();
        if (this.binary.isSinglePoint()) {
            this.binary.setFigures(new Figure[]{new Figure(1, 0)});
            this.binary.setShapes(new Shape[]{new Shape(-1, 0, 2)});
        } else if (this.binary.hasSingleLineSegment()) {
            this.binary.setFigures(new Figure[]{new Figure(1, 0)});
            this.binary.setShapes(new Shape[]{new Shape(-1, 0, 1)});
        } else {
            this.readFigures();
            this.readShapes();
        }
    }

    private void readNumberOfPoints() throws IOException {
        if (this.binary.isSinglePoint()) {
            this.binary.setNumberOfPoints(1);
        } else if (this.binary.hasSingleLineSegment()) {
            this.binary.setNumberOfPoints(2);
        } else {
            this.binary.setNumberOfPoints(this.dis.readInt());
        }
    }

    private void readCoordinates() throws IOException {
        Coordinate[] coordinates = new Coordinate[this.binary.getNumberOfPoints()];
        for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
            coordinates[i] = this.readCoordinate();
        }
        this.binary.setCoordinates(coordinates);
    }

    private void readShapes() throws IOException {
        int numberOfShapes = this.dis.readInt();
        Shape[] shapesMetadata = new Shape[numberOfShapes];
        for (int i = 0; i < numberOfShapes; ++i) {
            int parentOffset = this.dis.readInt();
            int figureOffset = this.dis.readInt();
            byte shapeType = this.dis.readByte();
            shapesMetadata[i] = new Shape(parentOffset, figureOffset, shapeType);
        }
        this.binary.setShapes(shapesMetadata);
    }

    private void readFigures() throws IOException {
        int numberOfFigures = this.dis.readInt();
        Figure[] figuresMetadata = new Figure[numberOfFigures];
        for (int i = 0; i < numberOfFigures; ++i) {
            byte figureAttribute = this.dis.readByte();
            int figurePointOffset = this.dis.readInt();
            figuresMetadata[i] = new Figure(figureAttribute, figurePointOffset);
        }
        this.binary.setFigures(figuresMetadata);
    }

    private void readMValues() throws IOException {
        if (this.binary.hasM()) {
            for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
                this.dis.readDouble();
            }
        }
    }

    private void readZValues() throws IOException {
        if (this.binary.hasZ()) {
            for (int i = 0; i < this.binary.getNumberOfPoints(); ++i) {
                this.binary.getCoordinates()[i].setZ(this.dis.readDouble());
            }
        }
    }

    private Coordinate readCoordinate() throws IOException {
        return new Coordinate(this.dis.readDouble(), this.dis.readDouble());
    }
}

