/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.sqlserver.SQLServerDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class SQLServerDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"sqlserver", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param INTSEC = new DataAccessFactory.Param("Integrated Security", Boolean.class, "Login as current windows user account. Works only in windows. Ignores user and password settings.", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param NATIVE_PAGING = new DataAccessFactory.Param("Use Native Paging", Boolean.class, "Use native paging for sql queries. For some sets of data, native paging can have a performance impact.", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param GEOMETRY_METADATA_TABLE = new DataAccessFactory.Param("Geometry metadata table", String.class, "The optional table containing geometry metadata (geometry type and srid). Can be expressed as 'schema.name' or just 'name'", false);
    public static final DataAccessFactory.Param NATIVE_SERIALIZATION = new DataAccessFactory.Param("Use native geometry serialization", Boolean.class, "Use native SQL Server serialization, or WKB serialization.", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param FORCE_SPATIAL_INDEX = new DataAccessFactory.Param("Force spatial index usage via hints", Boolean.class, "When enabled, spatial filters will be accompained by a WITH INDEX sql hint forcing the usage of the spatial index.", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param TABLE_HINTS = new DataAccessFactory.Param("Table hints", String.class, "These table hints will be added to every select query.", false, (Object)"");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", false);
    public static final DataAccessFactory.Param INSTANCE = new DataAccessFactory.Param("instance", String.class, "Instance Name", false);

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new SQLServerDialect(dataStore);
    }

    @Override
    protected String getDatabaseID() {
        return (String)SQLServerDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "Microsoft SQL Server";
    }

    @Override
    protected String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    protected String getValidationQuery() {
        return "select 1";
    }

    @Override
    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(SQLServerDataStoreFactory.PORT.key, PORT);
        parameters.put(SQLServerDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(SQLServerDataStoreFactory.INTSEC.key, INTSEC);
        parameters.put(SQLServerDataStoreFactory.NATIVE_PAGING.key, NATIVE_PAGING);
        parameters.put(SQLServerDataStoreFactory.NATIVE_SERIALIZATION.key, NATIVE_SERIALIZATION);
        parameters.put(SQLServerDataStoreFactory.GEOMETRY_METADATA_TABLE.key, GEOMETRY_METADATA_TABLE);
        parameters.put(SQLServerDataStoreFactory.FORCE_SPATIAL_INDEX.key, FORCE_SPATIAL_INDEX);
        parameters.put(SQLServerDataStoreFactory.TABLE_HINTS.key, TABLE_HINTS);
        parameters.put(SQLServerDataStoreFactory.INSTANCE.key, INSTANCE);
    }

    @Override
    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        String instance = (String)INSTANCE.lookUp(params);
        String url = "jdbc:" + this.getDatabaseID() + "://" + host;
        if (port != null) {
            url = url + ":" + port;
        } else if (instance != null) {
            url = url + "\\" + instance;
        }
        if (db != null) {
            url = url + "/" + db;
        }
        Boolean intsec = (Boolean)INTSEC.lookUp(params);
        if (db != null) {
            url = url.substring(0, url.lastIndexOf("/")) + (db != null ? ";DatabaseName=" + db : "");
        }
        if (intsec != null && intsec.booleanValue()) {
            url = url + ";integratedSecurity=true";
        }
        return url;
    }

    @Override
    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        Integer port = null;
        String instance = null;
        try {
            port = (Integer)PORT.lookUp(params);
            instance = (String)INSTANCE.lookUp(params);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return port != null || instance != null;
    }

    @Override
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        String tableHints;
        Boolean forceSpatialIndexes;
        SQLServerDialect dialect = (SQLServerDialect)dataStore.getSQLDialect();
        String metadataTable = (String)GEOMETRY_METADATA_TABLE.lookUp(params);
        dialect.setGeometryMetadataTable(metadataTable);
        Boolean useNativePaging = (Boolean)NATIVE_PAGING.lookUp(params);
        dialect.setUseOffSetLimit(useNativePaging == null || Boolean.TRUE.equals(useNativePaging));
        Boolean useNativeSerialization = (Boolean)NATIVE_SERIALIZATION.lookUp(params);
        if (useNativeSerialization != null) {
            dialect.setUseNativeSerialization(useNativeSerialization);
        }
        if ((forceSpatialIndexes = (Boolean)FORCE_SPATIAL_INDEX.lookUp(params)) != null) {
            dialect.setForceSpatialIndexes(forceSpatialIndexes);
        }
        if ((tableHints = (String)TABLE_HINTS.lookUp(params)) != null) {
            dialect.setTableHints(tableHints);
        }
        return dataStore;
    }
}

