/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver.jtds;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class JTDSClobConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(JTDSClobConverterFactory.class);
    JTDSDateConverter converter = new JTDSDateConverter();
    static final Class<?> JTDS_CLOB;
    static final Method JTDS_GET_CHARS;
    static final Method JTDS_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (JTDS_CLOB == null) {
            LOGGER.fine("Failed to find JTDS jar");
            return null;
        }
        if (!String.class.equals(target)) {
            LOGGER.finest("Target not a string");
            return null;
        }
        if (!JTDS_CLOB.isAssignableFrom(source)) {
            LOGGER.finest("Source not a clob");
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> jTDSClobClass = null;
        try {
            jTDSClobClass = Class.forName("net.sourceforge.jtds.jdbc.ClobImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (jTDSClobClass == null) {
            JTDS_CLOB = null;
            JTDS_GET_CHARS = null;
            JTDS_LENGTH = null;
        } else {
            try {
                JTDS_CLOB = jTDSClobClass;
                JTDS_LENGTH = JTDS_CLOB.getMethod("length", new Class[0]);
                JTDS_GET_CHARS = JTDS_CLOB.getMethod("getSubString", Long.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the jtds clob converter", e);
            }
        }
    }

    class JTDSDateConverter
    implements Converter {
        JTDSDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)JTDS_LENGTH.invoke(source, new Object[0])).intValue();
            String buffer = (String)JTDS_GET_CHARS.invoke(source, 1L, length);
            return (T)buffer;
        }
    }
}

