/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSNonPositiveIntegerBinding
implements SimpleBinding {
    final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    final BigInteger MIN_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);

    @Override
    public QName getTarget() {
        return XS.NONPOSITIVEINTEGER;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return BigInteger.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        BigInteger number = (BigInteger)value;
        if (BigInteger.ZERO.compareTo(number) < 0) {
            throw new IllegalArgumentException("Value '" + number + "' must be non-positive (0 or below).");
        }
        if (this.MIN_INTEGER.compareTo(number) <= 0) {
            return number.intValue();
        }
        if (this.MIN_LONG.compareTo(number) <= 0) {
            return number.longValue();
        }
        return number;
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Number number = (Number)object;
        if (number.longValue() > 0L) {
            throw new IllegalArgumentException("Value '" + number + "' must be non-positive (0 or below).");
        }
        return value;
    }
}

