/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.net.URI;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.IgnoreHandler;
import org.geotools.xml.handlers.xsi.RootHandler;
import org.geotools.xml.schema.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XSISAXHandler
extends DefaultHandler {
    protected static final Logger logger = Logging.getLogger(XSISAXHandler.class);
    private Stack handlers = new Stack();
    private Schema schema = null;
    protected RootHandler rootHandler = null;
    private Locator locator;
    private StringBuffer characters = new StringBuffer();

    private XSISAXHandler() {
    }

    public XSISAXHandler(URI uri) {
        this.rootHandler = new RootHandler(uri);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) {
        this.rootHandler.startPrefixMapping(arg0, arg1);
    }

    @Override
    public void endDocument() {
        this.handlers.pop();
    }

    @Override
    public void startDocument() {
        try {
            this.handlers.push(this.rootHandler);
        }
        catch (RuntimeException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    private void handleCharacters() throws SAXException {
        String text = this.characters.toString();
        this.characters.setLength(0);
        if (text.length() == 0) {
            return;
        }
        XSIElementHandler peek = null;
        try {
            if (text != null && !"".equals(text.trim())) {
                peek = (XSIElementHandler)this.handlers.peek();
                peek.characters(text);
            }
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleCharacters();
        logger.fine("END: " + qName);
        try {
            XSIElementHandler element = (XSIElementHandler)this.handlers.pop();
            element.endElement(namespaceURI, localName);
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.characters.setLength(0);
        logger.fine("START: " + qName);
        try {
            XSIElementHandler eh = ((XSIElementHandler)this.handlers.peek()).getHandler(namespaceURI, localName);
            logger.finest("Parent Node = " + ((XSIElementHandler)this.handlers.peek()).getClass().getName());
            if (eh == null) {
                eh = new IgnoreHandler();
            }
            logger.finest("This Node = " + eh.getClass().getName());
            logger.finest("This Node = " + localName + " :: " + namespaceURI);
            this.handlers.push(eh);
            eh.startElement(namespaceURI, localName, atts);
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    public static void setLogLevel(Level l) {
        logger.setLevel(l);
        XSIElementHandler.setLogLevel(l);
    }

    public Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = this.rootHandler.getSchema();
        }
        return this.schema;
    }

    @Override
    public void error(SAXParseException exception) {
        logger.severe("ERROR " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        logger.severe("FATAL " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) {
        logger.warning("WARN " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }
}

