/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle.sdo;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import org.geotools.data.oracle.sdo.SDO;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryConverter {
    protected OracleConnection connection;
    GeometryFactory geometryFactory;
    public static final String DATATYPE = "MDSYS.SDO_GEOMETRY";

    public GeometryConverter(OracleConnection connection) {
        this(connection, new GeometryFactory());
    }

    public GeometryConverter(OracleConnection connection, GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.connection = connection;
    }

    public String getDataTypeName() {
        return DATATYPE;
    }

    public boolean isCapable(Geometry geom) {
        if (geom == null) {
            return true;
        }
        if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon || geom instanceof GeometryCollection) {
            int d = SDO.D(geom);
            int l = SDO.L(geom);
            return l == 0 && (d == 2 || d == 3);
        }
        return false;
    }

    public Geometry asGeometry(OracleStruct sdoGeometry) throws SQLException {
        if (sdoGeometry == null) {
            return null;
        }
        Object[] data = sdoGeometry.getAttributes();
        int GTYPE = this.asInteger((Number)data[0], 0);
        int SRID = this.asInteger((Number)data[1], -1);
        double[] POINT = this.asDoubleArray((OracleStruct)data[2], Double.NaN);
        int[] ELEMINFO = this.asIntArray((OracleArray)data[3], 0);
        double[] ORDINATES = this.asDoubleArray((OracleArray)data[4], Double.NaN);
        return SDO.create(this.geometryFactory, GTYPE, SRID, POINT, ELEMINFO, ORDINATES);
    }

    public OracleStruct toSDO(Geometry geom) throws SQLException {
        return this.toSDO(geom, geom.getSRID());
    }

    public OracleStruct toSDO(Geometry geom, int srid) throws SQLException {
        OracleArray SDO_ORDINATES;
        OracleArray SDO_ELEM_INFO;
        OracleStruct SDO_POINT;
        if (geom == null || geom.isEmpty()) {
            return this.asEmptyDataType();
        }
        int gtype = SDO.gType(geom);
        NUMBER SDO_GTYPE = new NUMBER(gtype);
        NUMBER SDO_SRID = srid == -1 || srid == 0 ? null : new NUMBER(srid);
        double[] point = SDO.point(geom);
        if (point == null) {
            Envelope env = geom.getEnvelopeInternal();
            if (env.getWidth() > 0.0 && env.getHeight() > 0.0 && !(geom instanceof GeometryCollection) && geom.isRectangle()) {
                int[] elemInfo = new int[]{1, 1003, 3};
                double[] ordinates = SDO.D(geom) == 2 ? new double[]{env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY()} : new double[]{env.getMinX(), env.getMinY(), 0.0, env.getMaxX(), env.getMaxY(), 0.0};
                SDO_POINT = null;
                SDO_ELEM_INFO = this.toARRAY(elemInfo, "MDSYS.SDO_ELEM_INFO_ARRAY");
                SDO_ORDINATES = this.toARRAY(ordinates, "MDSYS.SDO_ORDINATE_ARRAY");
            } else {
                int[] elemInfo = SDO.elemInfo(geom);
                double[] ordinates = SDO.ordinates(geom);
                SDO_POINT = null;
                SDO_ELEM_INFO = this.toARRAY(elemInfo, "MDSYS.SDO_ELEM_INFO_ARRAY");
                SDO_ORDINATES = this.toARRAY(ordinates, "MDSYS.SDO_ORDINATE_ARRAY");
            }
        } else {
            Datum[] data = new Datum[]{this.toNUMBER(point[0]), this.toNUMBER(point[1]), this.toNUMBER(point[2])};
            SDO_POINT = this.toSTRUCT(data, "MDSYS.SDO_POINT_TYPE");
            SDO_ELEM_INFO = null;
            SDO_ORDINATES = null;
        }
        Object[] attributes = new Object[]{SDO_GTYPE, SDO_SRID, SDO_POINT, SDO_ELEM_INFO, SDO_ORDINATES};
        return this.toSTRUCT(attributes, DATATYPE);
    }

    protected OracleStruct asEmptyDataType() throws SQLException {
        return this.toSTRUCT((Datum[])null, DATATYPE);
    }

    protected final OracleStruct toSTRUCT(Datum[] attributes, String dataType) throws SQLException {
        if (dataType.startsWith("*.")) {
            dataType = "DRA." + dataType.substring(2);
        }
        return (OracleStruct)this.connection.createStruct(dataType, (Object[])attributes);
    }

    private OracleStruct toSTRUCT(Object[] attributes, String dataType) throws SQLException {
        if (dataType.startsWith("*.")) {
            dataType = "DRA." + dataType.substring(2);
        }
        return (OracleStruct)this.connection.createStruct(dataType, attributes);
    }

    protected final OracleArray toARRAY(double[] doubles, String dataType) throws SQLException {
        return this.connection.createARRAY(dataType, (Object)doubles);
    }

    protected final OracleArray toORDINATE(CoordinateList list, double[][] measures, int D) throws SQLException {
        int LENGTH = measures != null ? measures.length : 0;
        int LEN = D + LENGTH;
        Datum[] data = new Datum[list.size() * LEN];
        int offset = 0;
        int index = 0;
        for (Coordinate coord : list) {
            data[offset++] = this.toNUMBER(coord.x);
            data[offset++] = this.toNUMBER(coord.y);
            if (D == 3) {
                data[offset++] = this.toNUMBER(coord.x);
            }
            for (int j = 0; j < LENGTH; ++j) {
                data[offset++] = this.toNUMBER(measures[j][index]);
            }
            ++index;
        }
        return this.connection.createARRAY("MDSYS.SDO_ORDINATE_ARRAY", (Object)data);
    }

    protected final OracleArray toORDINATE(double[] ords) throws SQLException {
        int LENGTH = ords.length;
        Datum[] data = new Datum[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            data[i] = this.toNUMBER(ords[i]);
        }
        return this.connection.createARRAY("MDSYS.SDO_ORDINATE_ARRAY", (Object)data);
    }

    protected final OracleArray toATTRIBUTE(double[] ords, String desc) throws SQLException {
        int LENGTH = ords.length;
        Datum[] data = new Datum[LENGTH];
        for (int i = 0; i < LENGTH; ++i) {
            data[i] = this.toNUMBER(ords[i]);
        }
        return this.connection.createARRAY(desc, (Object)data);
    }

    protected final NUMBER toNUMBER(double number) throws SQLException {
        if (Double.isNaN(number)) {
            return null;
        }
        return new NUMBER(number);
    }

    protected final OracleArray toARRAY(int[] ints, String dataType) throws SQLException {
        return this.connection.createARRAY(dataType, (Object)ints);
    }

    protected final NUMBER toNUMBER(int number) {
        return new NUMBER(number);
    }

    protected final CHAR toCHAR(String s) {
        if (s.length() > 1) {
            s = Character.valueOf(s.charAt(0)).toString();
        }
        try {
            return new CHAR(s, CharacterSet.make((int)31));
        }
        catch (SQLException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            return null;
        }
    }

    protected int asInteger(Datum datum, int DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return datum.intValue();
    }

    private int asInteger(Number datum, int DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return datum.intValue();
    }

    protected double asDouble(Datum datum, double DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return ((NUMBER)datum).doubleValue();
    }

    private double asDouble(Number datum, double DEFAULT) throws SQLException {
        if (datum == null) {
            return DEFAULT;
        }
        return datum.doubleValue();
    }

    protected double[] asDoubleArray(OracleStruct struct, double DEFAULT) throws SQLException {
        if (struct == null) {
            return null;
        }
        return this.asDoubleArray((Number[])Arrays.copyOf(struct.getAttributes(), struct.getAttributes().length, Number[].class), DEFAULT);
    }

    protected double[] asDoubleArray(OracleArray array, double DEFAULT) throws SQLException {
        if (array == null) {
            return null;
        }
        if (DEFAULT == 0.0) {
            return array.getDoubleArray();
        }
        return this.asDoubleArray((Number[])array.getArray(), DEFAULT);
    }

    protected double[] asDoubleArray(Datum[] data, double DEFAULT) throws SQLException {
        if (data == null) {
            return null;
        }
        double[] array = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            array[i] = this.asDouble(data[i], DEFAULT);
        }
        return array;
    }

    private double[] asDoubleArray(Number[] data, double DEFAULT) throws SQLException {
        if (data == null) {
            return null;
        }
        double[] array = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            array[i] = this.asDouble(data[i], DEFAULT);
        }
        return array;
    }

    protected int[] asIntArray(OracleArray array, int DEFAULT) throws SQLException {
        if (array == null) {
            return null;
        }
        if (DEFAULT == 0) {
            return array.getIntArray();
        }
        return this.asIntArray((Datum[])array.getArray(), DEFAULT);
    }

    protected int[] asIntArray(Datum[] data, int DEFAULT) throws SQLException {
        if (data == null) {
            return null;
        }
        int[] array = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            array[i] = this.asInteger(data[i], DEFAULT);
        }
        return array;
    }
}

