/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.PdfPatternCanvas;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.svg.SvgConstants;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgPaintServer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.TransformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer
implements ISvgPaintServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternSvgNodeRenderer.class);
    private static final double CONVERT_COEFF = 0.75;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PatternSvgNodeRenderer copy = new PatternSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color createColor(SvgDrawContext context, Rectangle objectBoundingBox, float objectBoundingBoxMargin, float parentOpacity) {
        if (!context.pushPatternId(this.getAttribute("id"))) {
            return null;
        }
        try {
            PdfPattern.Tiling tilingPattern = this.createTilingPattern(context, objectBoundingBox);
            this.drawPatternContent(context, tilingPattern);
            PatternColor patternColor = tilingPattern == null ? null : new PatternColor((PdfPattern)tilingPattern);
            return patternColor;
        }
        finally {
            context.popPatternId();
        }
    }

    private PdfPattern.Tiling createTilingPattern(SvgDrawContext context, Rectangle objectBoundingBox) {
        Rectangle bbox;
        double yStep;
        boolean isObjectBoundingBoxInPatternUnits = this.isObjectBoundingBoxInPatternUnits();
        boolean isObjectBoundingBoxInPatternContentUnits = this.isObjectBoundingBoxInPatternContentUnits();
        Rectangle originalPatternRectangle = this.calculateOriginalPatternRectangle(context, isObjectBoundingBoxInPatternUnits);
        double xStep = originalPatternRectangle.getWidth();
        if (!PatternSvgNodeRenderer.xStepYStepAreValid(xStep, yStep = (double)originalPatternRectangle.getHeight())) {
            return null;
        }
        AffineTransform patternMatrixTransform = context.getCurrentCanvasTransform();
        patternMatrixTransform.concatenate(this.getPatternTransform());
        if (isObjectBoundingBoxInPatternUnits) {
            patternMatrixTransform.concatenate(PatternSvgNodeRenderer.getTransformToUserSpaceOnUse(objectBoundingBox));
        }
        patternMatrixTransform.translate((double)originalPatternRectangle.getX(), (double)originalPatternRectangle.getY());
        float[] viewBoxValues = this.getViewBoxValues();
        if (viewBoxValues.length < 4) {
            if (isObjectBoundingBoxInPatternUnits != isObjectBoundingBoxInPatternContentUnits) {
                double scaleY;
                double scaleX;
                if (isObjectBoundingBoxInPatternContentUnits) {
                    scaleX = (double)objectBoundingBox.getWidth() / 0.75;
                    scaleY = (double)objectBoundingBox.getHeight() / 0.75;
                } else {
                    scaleX = 0.75 / (double)objectBoundingBox.getWidth();
                    scaleY = 0.75 / (double)objectBoundingBox.getHeight();
                }
                patternMatrixTransform.scale(scaleX, scaleY);
                xStep /= scaleX;
                yStep /= scaleY;
            }
            bbox = new Rectangle(0.0f, 0.0f, (float)xStep, (float)yStep);
        } else {
            if (PatternSvgNodeRenderer.isViewBoxInvalid(viewBoxValues)) {
                return null;
            }
            if (isObjectBoundingBoxInPatternUnits) {
                double scaleX = 0.75 / (double)objectBoundingBox.getWidth();
                double scaleY = 0.75 / (double)objectBoundingBox.getHeight();
                patternMatrixTransform.scale(scaleX, scaleY);
                xStep /= scaleX;
                yStep /= scaleY;
            }
            Rectangle viewBox = new Rectangle(viewBoxValues[0], viewBoxValues[1], viewBoxValues[2], viewBoxValues[3]);
            Rectangle appliedViewBox = this.calculateAppliedViewBox(viewBox, xStep, yStep);
            patternMatrixTransform.translate((double)appliedViewBox.getX(), (double)appliedViewBox.getY());
            double scaleX = (double)appliedViewBox.getWidth() / (double)viewBox.getWidth();
            double scaleY = (double)appliedViewBox.getHeight() / (double)viewBox.getHeight();
            patternMatrixTransform.scale(scaleX, scaleY);
            patternMatrixTransform.translate((double)(-viewBox.getX()), (double)(-viewBox.getY()));
            double bboxXOriginal = (double)viewBox.getX() - (double)appliedViewBox.getX() / scaleX;
            double bboxYOriginal = (double)viewBox.getY() - (double)appliedViewBox.getY() / scaleY;
            bbox = new Rectangle((float)bboxXOriginal, (float)bboxYOriginal, (float)(xStep /= scaleX), (float)(yStep /= scaleY));
        }
        return PatternSvgNodeRenderer.createColoredTilingPatternInstance(patternMatrixTransform, bbox, xStep, yStep);
    }

    private Rectangle calculateAppliedViewBox(Rectangle viewBox, double xStep, double yStep) {
        String[] preserveAspectRatio = this.retrieveAlignAndMeet();
        Rectangle patternRect = new Rectangle(0.0f, 0.0f, (float)xStep, (float)yStep);
        return SvgCoordinateUtils.applyViewBox(viewBox, patternRect, preserveAspectRatio[0], preserveAspectRatio[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPatternContent(SvgDrawContext context, PdfPattern.Tiling pattern) {
        if (pattern == null) {
            return;
        }
        PdfPatternCanvas patternCanvas = new PdfPatternCanvas(pattern, context.getCurrentCanvas().getDocument());
        context.pushCanvas((PdfCanvas)patternCanvas);
        try {
            for (ISvgNodeRenderer renderer : this.getChildren()) {
                renderer.draw(context);
            }
        }
        finally {
            context.popCanvas();
        }
    }

    private Rectangle calculateOriginalPatternRectangle(SvgDrawContext context, boolean isObjectBoundingBoxInPatternUnits) {
        double yStep;
        double xStep;
        double yOffset;
        double xOffset;
        if (isObjectBoundingBoxInPatternUnits) {
            xOffset = SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("x"), 0.0) * 0.75;
            yOffset = SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("y"), 0.0) * 0.75;
            xStep = SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("width"), 0.0) * 0.75;
            yStep = SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("height"), 0.0) * 0.75;
        } else {
            Rectangle currentViewPort = context.getCurrentViewPort();
            double viewPortX = currentViewPort.getX();
            double viewPortY = currentViewPort.getY();
            double viewPortWidth = currentViewPort.getWidth();
            double viewPortHeight = currentViewPort.getHeight();
            float em = this.getCurrentFontSize();
            float rem = context.getCssContext().getRootFontSize();
            xOffset = SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("x"), viewPortX, viewPortX, viewPortWidth, em, rem);
            yOffset = SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("y"), viewPortY, viewPortY, viewPortHeight, em, rem);
            xStep = SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("width"), viewPortX, viewPortX, viewPortWidth, em, rem);
            yStep = SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("height"), viewPortY, viewPortY, viewPortHeight, em, rem);
        }
        return new Rectangle((float)xOffset, (float)yOffset, (float)xStep, (float)yStep);
    }

    private boolean isObjectBoundingBoxInPatternUnits() {
        String patternUnits = this.getAttribute(SvgConstants.Attributes.PATTERN_UNITS);
        if ("userSpaceOnUse".equals(patternUnits)) {
            return false;
        }
        if (patternUnits != null && !"objectBoundingBox".equals(patternUnits)) {
            LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize patternUnits value {0}", (Object[])new Object[]{patternUnits}));
        }
        return true;
    }

    private boolean isObjectBoundingBoxInPatternContentUnits() {
        String patternContentUnits = this.getAttribute(SvgConstants.Attributes.PATTERN_CONTENT_UNITS);
        if ("objectBoundingBox".equals(patternContentUnits)) {
            return true;
        }
        if (patternContentUnits != null && !"userSpaceOnUse".equals(patternContentUnits)) {
            LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize patternContentUnits value {0}", (Object[])new Object[]{patternContentUnits}));
        }
        return false;
    }

    private static PdfPattern.Tiling createColoredTilingPatternInstance(AffineTransform patternAffineTransform, Rectangle bbox, double xStep, double yStep) {
        PdfPattern.Tiling coloredTilingPattern = new PdfPattern.Tiling(bbox, (float)xStep, (float)yStep, true);
        PatternSvgNodeRenderer.setPatternMatrix(coloredTilingPattern, patternAffineTransform);
        return coloredTilingPattern;
    }

    private static void setPatternMatrix(PdfPattern.Tiling pattern, AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            double[] patternMatrix = new double[6];
            affineTransform.getMatrix(patternMatrix);
            pattern.setMatrix(new PdfArray(patternMatrix));
        }
    }

    private static AffineTransform getTransformToUserSpaceOnUse(Rectangle objectBoundingBox) {
        AffineTransform transform = new AffineTransform();
        transform.translate((double)objectBoundingBox.getX(), (double)objectBoundingBox.getY());
        transform.scale((double)objectBoundingBox.getWidth() / 0.75, (double)objectBoundingBox.getHeight() / 0.75);
        return transform;
    }

    private static boolean xStepYStepAreValid(double xStep, double yStep) {
        if (xStep < 0.0 || yStep < 0.0) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(MessageFormatUtil.format((String)"Pattern width or height is negative value. This pattern will not be rendered.", (Object[])new Object[0]));
            }
            return false;
        }
        if (xStep == 0.0 || yStep == 0.0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(MessageFormatUtil.format((String)"Pattern width or height is zero. This pattern will not be rendered.", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private static boolean isViewBoxInvalid(float[] viewBoxValues) {
        if (viewBoxValues[2] == 0.0f || viewBoxValues[3] == 0.0f) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(MessageFormatUtil.format((String)"The viewBox width or height is zero. The element with this viewBox will not be rendered.", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    private AffineTransform getPatternTransform() {
        String patternTransform = this.getAttribute(SvgConstants.Attributes.PATTERN_TRANSFORM);
        if (patternTransform != null && !patternTransform.isEmpty()) {
            return TransformUtils.parseTransform(patternTransform);
        }
        return new AffineTransform();
    }
}

