/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RsgbBRPTransformer
extends RsgbTransformer {
    private static final Log log = LogFactory.getLog(RsgbBRPTransformer.class);
    private StagingProxy staging;
    private static final String GEEN_WAARDE = "geenWaarde";

    public RsgbBRPTransformer(String pathToXsl, StagingProxy staging) throws TransformerConfigurationException, ParserConfigurationException {
        super(pathToXsl);
        this.staging = staging;
    }

    @Override
    public String transformToDbXml(Bericht bericht) throws SAXException, IOException, TransformerConfigurationException, TransformerException {
        String current = super.transformToDbXml(bericht);
        StringBuilder loadLog = new StringBuilder();
        try {
            Bericht old = this.staging.getPreviousBericht(bericht, loadLog);
            if (old != null) {
                Document d = RsgbBRPTransformer.merge(old.getDbXml(), current);
                String mergedDBXML = RsgbBRPTransformer.print(d);
                bericht.setDbXml(mergedDBXML);
                current = mergedDBXML;
            }
        }
        catch (SQLException ex) {
            log.error((Object)"Cannot retrieve old bericht: ", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot retrieve old bericht: ", (Throwable)ex);
        }
        return current;
    }

    @Override
    public Node transformToDbXmlNode(Bericht bericht) throws SAXException, IOException, TransformerConfigurationException, TransformerException {
        Node n = super.transformToDbXmlNode(bericht);
        return n;
    }

    protected static Document merge(String oldFile, String newFile) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression expression = xpath.compile("/root/data");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document base = docBuilder.parse(new InputSource(new StringReader(oldFile)));
        Element old = (Element)expression.evaluate(base, XPathConstants.NODE);
        if (old == null) {
            throw new IOException(oldFile + ": expression does not evaluate to node");
        }
        Document merge = docBuilder.parse(new InputSource(new StringReader(newFile)));
        Node newNode = (Node)expression.evaluate(merge, XPathConstants.NODE);
        RsgbBRPTransformer.merge(base, newNode, old, true);
        return base;
    }

    private static void merge(Document base, Node newNode, Element old, boolean first) {
        while (newNode.hasChildNodes()) {
            Node newChild = newNode.getFirstChild();
            newNode.removeChild(newChild);
            String name = newChild.getNodeName();
            NodeList nl = old.getElementsByTagName(name);
            if (nl.getLength() == 0) {
                newChild = base.importNode(newChild, true);
                newChild.setTextContent(newChild.getTextContent());
                old.appendChild(newChild);
                continue;
            }
            Element oldItem = (Element)nl.item(0);
            if (first) {
                RsgbBRPTransformer.merge(base, newChild, oldItem, false);
                continue;
            }
            String content = newChild.getTextContent();
            if (content.equals(GEEN_WAARDE)) {
                oldItem.setTextContent("");
                continue;
            }
            if (content.equals("")) continue;
            oldItem.setTextContent(RsgbBRPTransformer.sanitizeValue(newChild.getTextContent()));
        }
    }

    private static String sanitizeValue(String val) {
        if (val.contains(GEEN_WAARDE)) {
            String newValue = val.replaceAll("geenWaarde ", "");
            newValue = newValue.replaceAll(GEEN_WAARDE, "");
            return newValue;
        }
        return val;
    }

    protected static String print(Document doc) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }
}

