/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.checks;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.events.Event;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.events.PdfDocumentEvent;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.Style;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nl.b3p.brmo.loader.checks.Afgifte;
import nl.b3p.brmo.loader.entity.Bericht;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfgiftelijstReport {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final SimpleDateFormat xlsDate = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss,SSSSSSSSS");
    private static final Log log = LogFactory.getLog(AfgiftelijstReport.class);
    private String datum;

    public void createReport(List<Afgifte> afgiftes, String inputFileName, File output) throws FileNotFoundException {
        this.datum = this.sdf.format(new Date());
        PdfDocument pdfDoc = new PdfDocument(new PdfWriter(output));
        pdfDoc.setDefaultPageSize(PageSize.A4.rotate());
        Footer footerHandler = new Footer(pdfDoc);
        pdfDoc.addEventHandler("EndPdfPage", (IEventHandler)footerHandler);
        try (Document doc = new Document(pdfDoc);){
            this.createFirstPage(doc, inputFileName);
            this.createTable(afgiftes, pdfDoc, doc);
            footerHandler.writeTotal(pdfDoc);
        }
        catch (IOException ex) {
            log.error((Object)"Cannot");
        }
    }

    private void createFirstPage(Document doc, String input) throws IOException {
        PdfFont bold = PdfFontFactory.createFont((String)"Times-Bold");
        Style style = (Style)((Style)((Style)new Style().setFont(bold)).setFontSize(16.0f)).setFontColor((Color)new DeviceRgb(21, 127, 204));
        Paragraph title = new Paragraph("BRMO Controle afgiftelijst");
        title.addStyle(style);
        Paragraph text = new Paragraph("Dit rapport is gegenereerd op " + this.datum + " op basis van de afgiftelijst " + input + ".");
        doc.add((IBlockElement)title);
        doc.add((IBlockElement)text);
    }

    protected void createTable(List<Afgifte> afgiftes, PdfDocument pdfDoc, Document doc) throws IOException {
        PdfFont font = PdfFontFactory.createFont((String)"Times-Roman");
        pdfDoc.addNewPage();
        doc.add(new AreaBreak());
        Table table = new Table(8).useAllAvailableWidth();
        table.setBorder((Border)new SolidBorder(1.0f));
        this.createHeaderRow(table);
        table.setFont(font);
        for (Afgifte afgifte : afgiftes) {
            this.createRow(afgifte, table);
        }
        doc.add((IBlockElement)table);
    }

    private void createHeaderRow(Table table) throws IOException {
        PdfFont font = PdfFontFactory.createFont((String)"Times-Bold");
        table.setFont(font);
        SolidBorder b = new SolidBorder(2.0f);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Klantnr.").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Contractnr.").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Datum").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Bestand").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Rapport via URL").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Geleverd").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("In staging").setFont(font))).setBorder((Border)b);
        table.addCell(new Cell().add((IBlockElement)new Paragraph("Status").setFont(font))).setBorder((Border)b);
    }

    private void createRow(Afgifte afgifte, Table table) {
        SolidBorder b = new SolidBorder(1.0f);
        table.addCell(afgifte.getKlantnummer()).setBorder((Border)b);
        table.addCell(afgifte.getContractnummer()).setBorder((Border)b);
        try {
            table.addCell(this.sdf.format(this.xlsDate.parse(afgifte.getDatum()))).setBorder((Border)b);
        }
        catch (ParseException ex) {
            table.addCell(afgifte.getDatum()).setBorder((Border)b);
        }
        table.addCell(afgifte.getBestandsnaam()).setBorder((Border)b);
        table.addCell(afgifte.isRapport() ? "Ja" : "Nee").setBorder((Border)b);
        table.addCell(afgifte.isGeleverd() ? "Ja" : "Nee").setBorder((Border)b);
        table.addCell(afgifte.isFoundInStaging() ? "Ja" : "Nee").setBorder((Border)b);
        table.addCell(this.getStatusString(afgifte)).setBorder((Border)b);
    }

    private String getStatusString(Afgifte afgifte) {
        String res = "";
        Map<Bericht.STATUS, Integer> stati = afgifte.getStatussen();
        for (Bericht.STATUS status : stati.keySet()) {
            if (!res.isEmpty()) {
                res = res + "\n";
            }
            res = res + status.name() + ":" + stati.get((Object)status);
        }
        if (res.isEmpty()) {
            res = "-";
        }
        return res;
    }

    protected class Footer
    implements IEventHandler {
        protected PdfFormXObject placeholder = new PdfFormXObject(new Rectangle(0.0f, 0.0f, this.side, this.side));
        protected float side = 20.0f;
        protected float x = 790.0f;
        protected float y = 5.0f;
        protected float space = 4.5f;
        protected float descent = 3.0f;

        public Footer(PdfDocument pdf) {
        }

        public void handleEvent(Event event) {
            PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
            PdfDocument pdf = docEvent.getDocument();
            PdfPage page = docEvent.getPage();
            int pageNumber = pdf.getPageNumber(page);
            Rectangle pageSize = page.getPageSize();
            PdfCanvas pdfCanvas = new PdfCanvas(page.getLastContentStream(), page.getResources(), pdf);
            Canvas canvas = new Canvas(pdfCanvas, pageSize);
            Paragraph p = new Paragraph().add("Pagina ").add(String.valueOf(pageNumber)).add(" van");
            Paragraph p2 = new Paragraph().add("B3Partners BRMO controlemodule - " + AfgiftelijstReport.this.datum);
            canvas.showTextAligned(p2, 35.0f, this.y, TextAlignment.LEFT);
            canvas.showTextAligned(p, this.x, this.y, TextAlignment.RIGHT);
            pdfCanvas.addXObjectAt((PdfXObject)this.placeholder, this.x + this.space, this.y - this.descent);
            pdfCanvas.release();
        }

        public void writeTotal(PdfDocument pdf) {
            Canvas canvas = new Canvas(this.placeholder, pdf);
            canvas.showTextAligned(String.valueOf(pdf.getNumberOfPages()), 0.0f, this.descent, TextAlignment.LEFT);
        }
    }
}

