/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.sql.Date;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;
import org.geotools.xs.XSUtils;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSDateBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DATE;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Date.class;
    }

    @Override
    public Date parse(InstanceComponent instance, Object value) throws Exception {
        Calendar calendar = DatatypeConverterImpl.getInstance().parseDate((String)value);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Date date = (Date)object;
        Calendar calendar = XSUtils.getConfiguredCalendar();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        return DatatypeConverterImpl.getInstance().printDate(calendar);
    }
}

