/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.sql.Time;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSTimeBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.TIME;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Time.class;
    }

    @Override
    public Time parse(InstanceComponent instance, Object value) throws Exception {
        Calendar calTime = DatatypeConverterImpl.getInstance().parseTime((String)value);
        Time time = new Time(calTime.getTimeInMillis());
        return time;
    }

    @Override
    public String encode(Object object, String value) {
        Time time = (Time)object;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        return DatatypeConverterImpl.getInstance().printTime(calendar);
    }
}

