/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XMLUtils;
import org.geotools.xsd.Binding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.EncoderDelegate;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.BindingPropertyExtractor;
import org.geotools.xsd.impl.BindingVisitorDispatch;
import org.geotools.xsd.impl.BindingWalker;
import org.geotools.xsd.impl.BindingWalkerFactoryImpl;
import org.geotools.xsd.impl.ElementEncoder;
import org.geotools.xsd.impl.GetPropertyExecutor;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Encoder {
    public static final QName COMMENT = new QName("http://www.geotools.org", "comment");
    static final String INDENT_AMOUNT_KEY = "{http://xml.apache.org/xslt}indent-amount";
    private XSDSchema schema;
    private SchemaIndex index;
    private BindingLoader bindingLoader;
    private MutablePicoContainer context;
    private BindingWalker bindingWalker;
    private List<PropertyExtractor> propertyExtractors;
    private ElementEncoder encoder;
    private Document doc;
    private NamespaceSupport namespaces;
    private ContentHandler serializer;
    private Map<String, String> schemaLocations;
    private Properties outputProps;
    private boolean namespaceAware = true;
    private boolean inline = false;
    private QName rootElementType;
    private Logger logger;
    private boolean relaxed = Boolean.parseBoolean(System.getProperty("encoder.relaxed", "true"));
    private Configuration configuration;

    public Encoder(Configuration configuration) {
        this(configuration, Encoder.getSchema(configuration));
    }

    public static XSDSchema getSchema(Configuration configuration) {
        try {
            return configuration.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Encoder(Configuration configuration, XSDSchema schema) {
        this.configuration = configuration;
        this.schema = schema;
        this.index = new SchemaIndexImpl(new XSDSchema[]{schema});
        this.bindingLoader = new BindingLoader(configuration.setupBindings());
        this.bindingWalker = new BindingWalker(this.bindingLoader);
        this.context = new DefaultPicoContainer();
        this.context.registerComponentInstance((Object)this);
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance((Object)bindingFactory);
        this.encoder = new ElementEncoder(this.bindingWalker, this.context);
        this.context.registerComponentInstance((Object)this.encoder);
        this.context.registerComponentInstance((Object)this.index);
        this.context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
        this.context = configuration.setupContext(this.context);
        this.encoder.setContext(this.context);
        this.schemaLocations = new HashMap<String, String>();
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger(Encoder.class);
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.encoder.setLogger(this.logger);
        this.namespaces = new NamespaceSupport();
        this.context.registerComponentInstance((Object)this.namespaces);
        this.context.registerComponentInstance((Object)new NamespaceSupportWrapper(this.namespaces));
        this.context.registerComponentInstance((Object)configuration);
        this.propertyExtractors = Schemas.getComponentInstancesOfType((PicoContainer)this.context, PropertyExtractor.class);
        this.propertyExtractors.add(0, new BindingPropertyExtractor(this, this.context));
        this.outputProps = new Properties();
        this.outputProps.setProperty(INDENT_AMOUNT_KEY, "2");
        configuration.setupEncoder(this);
    }

    public void setEncoding(Charset charset) {
        String charsetName = charset.name();
        this.outputProps.put("encoding", charsetName);
    }

    public Charset getEncoding() {
        String charsetName = this.outputProps.getProperty("encoding");
        return charsetName != null ? Charset.forName(charsetName) : null;
    }

    public void setOmitXMLDeclaration(boolean ommitXmlDeclaration) {
        this.outputProps.put("omit-xml-declaration", ommitXmlDeclaration ? "yes" : "no");
    }

    public boolean isOmitXMLDeclaration() {
        return "yes".equals(this.outputProps.get("omit-xml-declaration"));
    }

    public void setIndenting(boolean doIndent) {
        this.outputProps.put("indent", doIndent ? "yes" : "no");
    }

    public boolean isIndenting() {
        return "yes".equals(this.outputProps.get("indent"));
    }

    public void setIndentSize(int indentSize) {
        if (indentSize < 0) {
            throw new IllegalArgumentException("indentSize shall be >= 0: " + indentSize);
        }
        this.setIndenting(true);
        this.outputProps.setProperty(INDENT_AMOUNT_KEY, String.valueOf(indentSize));
    }

    public int getIndentSize() {
        if (this.outputProps.containsKey(INDENT_AMOUNT_KEY)) {
            return Integer.parseInt(this.outputProps.getProperty(INDENT_AMOUNT_KEY));
        }
        return 0;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 0) {
            throw new IllegalArgumentException("lineWidth shall be >= 0: " + lineWidth);
        }
    }

    public int getLineWidth() {
        return 72;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setRootElementType(QName rootElementType) {
        this.rootElementType = rootElementType;
    }

    public void setSchemaLocation(String namespaceURI, String location) {
        this.schemaLocations.put(namespaceURI, location);
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void encode(Object object, QName name, OutputStream out) throws IOException {
        TransformerHandler xmls;
        if (this.inline) {
            String msg = "Must use 'encode(Object,QName,ContentHandler)' when inline flag is set";
            throw new IllegalStateException(msg);
        }
        SAXTransformerFactory txFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            xmls = txFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        xmls.getTransformer().setOutputProperties(this.outputProps);
        xmls.getTransformer().setOutputProperty("method", "xml");
        xmls.setResult(new StreamResult(out));
        try {
            this.encode(object, name, xmls);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getCause() == null) {
                e.initCause(e.getException());
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    private boolean isNonStripedNestedElement(Object next, XSDElementDeclaration element) {
        if (!(next instanceof ComplexAttribute)) {
            return false;
        }
        ComplexAttribute complex = (ComplexAttribute)next;
        Collection nestedProperties = complex.getProperties();
        if (nestedProperties == null || nestedProperties.isEmpty()) {
            return false;
        }
        if (!nestedProperties.stream().allMatch(property -> property == null || property.getType().getName().equals((Object)complex.getType().getName()))) {
            return false;
        }
        for (XSDParticle childParticle : Schemas.getChildElementParticles(element.getTypeDefinition(), true)) {
            XSDElementDeclaration childElement = (XSDElementDeclaration)childParticle.getContent();
            if (!childElement.isElementDeclarationReference() || !(childElement = childElement.getResolvedElementDeclaration()).getType().getName().equals(complex.getType().getName().getLocalPart())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(Object object, QName name, ContentHandler handler) throws IOException, SAXException {
        Stack<EncodingEntry> encoded = null;
        if (this.namespaces.getPrefix("http://www.w3.org/2001/XMLSchema") == null) {
            this.namespaces.declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
        }
        try {
            void var6_13;
            Object entry;
            this.serializer = handler;
            if (!this.inline) {
                this.serializer.startDocument();
            }
            if (this.namespaceAware) {
                Enumeration<String> e = this.namespaces.getPrefixes();
                while (e.hasMoreElements()) {
                    String string = e.nextElement();
                    String uri = this.namespaces.getURI(string);
                    if ("xml".equals(string)) continue;
                    this.serializer.startPrefixMapping(string, uri);
                }
                for (Map.Entry entry2 : this.schema.getQNamePrefixToNamespaceMap().entrySet()) {
                    entry = entry2;
                    String pre = (String)entry.getKey();
                    String ns = (String)entry.getValue();
                    if ("http://www.w3.org/2001/XMLSchema".equals(ns) || this.namespaces.getPrefix(ns) != null) continue;
                    this.serializer.startPrefixMapping(pre != null ? pre : "", ns);
                    this.serializer.endPrefixMapping(pre != null ? pre : "");
                    this.namespaces.declarePrefix(pre != null ? pre : "", ns);
                }
                if (this.namespaces.getURI("") == null) {
                    this.namespaces.declarePrefix("", this.schema.getTargetNamespace());
                }
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                this.doc = docFactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                new IOException().initCause(parserConfigurationException);
            }
            encoded = new Stack<EncodingEntry>();
            XSDElementDeclaration xSDElementDeclaration = this.index.getElementDeclaration(name);
            if (xSDElementDeclaration == null) {
                QName typeDefintion = this.rootElementType;
                if (typeDefintion == null) {
                    typeDefintion = (QName)this.context.getComponentInstance((Object)"http://geotools.org/typeDefinition");
                }
                if (typeDefintion != null) {
                    XSDTypeDefinition type = this.index.getTypeDefinition(typeDefintion);
                    if (type == null) {
                        throw new NullPointerException();
                    }
                    XSDElementDeclaration xSDElementDeclaration2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xSDElementDeclaration2.setName(name.getLocalPart());
                    xSDElementDeclaration2.setTargetNamespace(name.getNamespaceURI());
                    xSDElementDeclaration2.setTypeDefinition(type);
                }
            }
            if (var6_13 == null) {
                String msg = "Could not find element declaration for:" + name;
                throw new IllegalArgumentException(msg);
            }
            encoded.add(new EncodingEntry(object, (XSDElementDeclaration)var6_13, null));
            while (!encoded.isEmpty()) {
                List sub;
                entry = (EncodingEntry)encoded.peek();
                if (((EncodingEntry)entry).encoding != null) {
                    if (!((EncodingEntry)entry).children.isEmpty()) {
                        Object[] child = ((EncodingEntry)entry).children.get(0);
                        XSDElementDeclaration element = ((XSDElementDeclaration)child[0]).getResolvedElementDeclaration();
                        Iterator itr = (Iterator)child[1];
                        if (itr.hasNext()) {
                            Object e = itr.next();
                            if (e instanceof EncoderDelegate) {
                                try {
                                    ((EncoderDelegate)e).encode(handler);
                                    continue;
                                }
                                catch (Exception e2) {
                                    throw new RuntimeException(e2);
                                }
                            }
                            if (e instanceof ComplexAttribute && this.relaxed && this.isNonStripedNestedElement(e, element)) {
                                for (Property property : ((ComplexAttribute)e).getProperties()) {
                                    encoded.push(new EncodingEntry(property, element, (EncodingEntry)entry));
                                }
                                continue;
                            }
                            encoded.push(new EncodingEntry(e, element, (EncodingEntry)entry));
                            continue;
                        }
                        Object object2 = child[2];
                        this.closeIterator(itr, object2);
                        ((EncodingEntry)entry).children.remove(0);
                        continue;
                    }
                    this.end(((EncodingEntry)entry).encoding, ((EncodingEntry)entry).element);
                    encoded.pop();
                    ((EncodingEntry)entry).object = null;
                    ((EncodingEntry)entry).element = null;
                    ((EncodingEntry)entry).encoding = null;
                    ((EncodingEntry)entry).children = null;
                    ((EncodingEntry)entry).parent = null;
                    continue;
                }
                if (((EncodingEntry)entry).element.isAbstract() && !(sub = this.safeCopy(((EncodingEntry)entry).element.getSubstitutionGroup())).isEmpty()) {
                    ArrayList matches = new ArrayList();
                    for (Object e : sub) {
                        XSDElementDeclaration e3 = (XSDElementDeclaration)e;
                        if (e3 == null || e3.equals(((EncodingEntry)entry).element) || e3.getName() == null) continue;
                        Binding binding = this.bindingLoader.loadBinding(new QName(e3.getTargetNamespace(), e3.getName()), (PicoContainer)this.context);
                        if (binding == null) {
                            XSDTypeDefinition type = e3.getType();
                            if (type == null || type.getName() == null) continue;
                            binding = this.bindingLoader.loadBinding(new QName(type.getTargetNamespace(), type.getName()), (PicoContainer)this.context);
                        }
                        if (binding == null) continue;
                        if (binding.getType() == null) {
                            this.logger.warning("Binding: " + binding.getTarget() + " returns null type.");
                            continue;
                        }
                        if (!binding.getType().isAssignableFrom(((EncodingEntry)entry).object.getClass())) continue;
                        matches.add(new Object[]{e3, binding});
                    }
                    if (matches.size() == 1) {
                        ((EncodingEntry)entry).element = (XSDElementDeclaration)((Object[])matches.get(0))[0];
                    } else if (!matches.isEmpty()) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            StringBuffer msg = new StringBuffer("Found multiple non-abstract bindings for ");
                            msg.append(((EncodingEntry)entry).element.getName()).append(": ");
                            Iterator iterator = matches.iterator();
                            while (iterator.hasNext()) {
                                Object[] match = (Object[])iterator.next();
                                msg.append(match.getClass().getName());
                                msg.append(", ");
                            }
                            this.logger.fine(msg.toString());
                        }
                        Collections.sort(matches, new MatchComparator());
                    }
                    if (!matches.isEmpty()) {
                        ((EncodingEntry)entry).element = (XSDElementDeclaration)((Object[])matches.get(0))[0];
                    }
                }
                if (((EncodingEntry)entry).element.isAbstract()) {
                    this.logger.fine(((EncodingEntry)entry).element.getName() + " is abstract");
                }
                ((EncodingEntry)entry).encoding = ((EncodingEntry)entry).parent != null ? (Element)this.encode(((EncodingEntry)entry).object, (XSDNamedComponent)((EncodingEntry)entry).element, ((EncodingEntry)entry).parent.element.getType()) : (Element)this.encode(((EncodingEntry)entry).object, (XSDNamedComponent)((EncodingEntry)entry).element);
                List attributes = this.index.getAttributes(((EncodingEntry)entry).element);
                for (Object value : attributes) {
                    Attr attr;
                    String local;
                    XSDAttributeDeclaration xSDAttributeDeclaration = (XSDAttributeDeclaration)value;
                    String ns = xSDAttributeDeclaration.getTargetNamespace();
                    if (((EncodingEntry)entry).encoding.getAttributeNS(ns, local = xSDAttributeDeclaration.getName()) != null && !"".equals(((EncodingEntry)entry).encoding.getAttributeNS(ns, local))) continue;
                    GetPropertyExecutor executor = new GetPropertyExecutor(((EncodingEntry)entry).object, (XSDNamedComponent)xSDAttributeDeclaration);
                    BindingVisitorDispatch.walk(object, this.bindingWalker, (XSDFeature)((EncodingEntry)entry).element, executor, this.context);
                    if (executor.getChildObject() == null || (attr = (Attr)this.encode(executor.getChildObject(), (XSDNamedComponent)xSDAttributeDeclaration)) == null) continue;
                    ((EncodingEntry)entry).encoding.setAttributeNodeNS(attr);
                }
                if (this.schemaLocations != null) {
                    if (!this.schemaLocations.isEmpty()) {
                        this.serializer.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        this.serializer.endPrefixMapping("xsi");
                        this.namespaces.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        StringBuffer schemaLocation = new StringBuffer();
                        Iterator<Map.Entry<String, String>> e = this.schemaLocations.entrySet().iterator();
                        while (e.hasNext()) {
                            Map.Entry<String, String> entry3 = e.next();
                            String namespaceURI = entry3.getKey();
                            String location = entry3.getValue();
                            schemaLocation.append(namespaceURI + " " + location);
                            if (!e.hasNext()) continue;
                            schemaLocation.append(" ");
                        }
                        ((EncodingEntry)entry).encoding.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocation.toString());
                    }
                    this.schemaLocations = null;
                }
                this.start(((EncodingEntry)entry).encoding, ((EncodingEntry)entry).element);
                for (PropertyExtractor propertyExtractor : this.propertyExtractors) {
                    if (!propertyExtractor.canHandle(((EncodingEntry)entry).object)) continue;
                    List list = propertyExtractor.properties(((EncodingEntry)entry).object, ((EncodingEntry)entry).element);
                    block19: for (Object o : list) {
                        XSDParticle cParticle;
                        XSDModelGroup xSDModelGroup;
                        Object[] tuple = (Object[])o;
                        XSDParticle particle = (XSDParticle)tuple[0];
                        XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                        if (child == null) continue;
                        if (child != null && COMMENT.getNamespaceURI().equals(child.getTargetNamespace()) && COMMENT.getLocalPart().equals(child.getName())) {
                            this.comment(child.getElement());
                            continue;
                        }
                        if (child.isElementDeclarationReference()) {
                            child = child.getResolvedElementDeclaration();
                        }
                        String ns = child.getTargetNamespace();
                        String local = child.getName();
                        for (int i = 0; i < ((EncodingEntry)entry).encoding.getChildNodes().getLength(); ++i) {
                            Node node = ((EncodingEntry)entry).encoding.getChildNodes().item(i);
                            if (node instanceof Element && (ns != null ? ns.equals(node.getNamespaceURI()) && local.equals(node.getLocalName()) : local.equals(node.getLocalName()))) continue block19;
                        }
                        Object obj = tuple[1];
                        if (obj == null) {
                            if (particle.getMinOccurs() == 0) continue;
                            if (!child.isNillable()) {
                                this.logger.fine("Property " + ns + ":" + local + " not found but minoccurs > 0 ");
                                continue;
                            }
                        }
                        int maxOccurs = 1;
                        if (particle.isSetMaxOccurs()) {
                            maxOccurs = particle.getMaxOccurs();
                        } else if (particle.eContainer() instanceof XSDModelGroup && (xSDModelGroup = (XSDModelGroup)particle.eContainer()).eContainer() instanceof XSDParticle && (cParticle = (XSDParticle)xSDModelGroup.eContainer()).isSetMaxOccurs()) {
                            maxOccurs = cParticle.getMaxOccurs();
                        }
                        if (maxOccurs == -1 || maxOccurs > 1) {
                            void var21_50;
                            Object collection;
                            Object var21_44 = null;
                            if (obj instanceof Iterator) {
                                Iterator iterator = (Iterator)obj;
                            } else if (obj != null && obj.getClass().isArray()) {
                                Object[] array = (Object[])obj;
                                Iterator<Object> iterator = Arrays.asList(array).iterator();
                            } else if (obj instanceof Collection) {
                                collection = (Collection)obj;
                                Iterator iterator = collection.iterator();
                            } else if (obj instanceof FeatureCollection) {
                                collection = (FeatureCollection)obj;
                                Iterator iterator = DataUtilities.iterator(collection.features());
                            } else {
                                SingleIterator singleIterator = new SingleIterator(obj);
                            }
                            ((EncodingEntry)entry).children.add(new Object[]{child, var21_50, obj});
                            continue;
                        }
                        ((EncodingEntry)entry).children.add(new Object[]{child, new SingleIterator(obj), obj});
                    }
                }
            }
            if (!this.inline) {
                this.serializer.endDocument();
            }
            this.index.destroy();
            if (encoded == null) return;
        }
        catch (Throwable throwable) {
            this.index.destroy();
            if (encoded == null) throw throwable;
            while (!encoded.isEmpty()) {
                EncodingEntry entry = (EncodingEntry)encoded.pop();
                if (entry.children.isEmpty()) continue;
                Object[] child = entry.children.get(0);
                Iterator itr = (Iterator)child[1];
                try {
                    this.closeIterator(itr, child[2]);
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        while (!encoded.isEmpty()) {
            EncodingEntry entry = (EncodingEntry)encoded.pop();
            if (entry.children.isEmpty()) continue;
            Object[] objectArray = entry.children.get(0);
            Iterator itr = (Iterator)objectArray[1];
            try {
                this.closeIterator(itr, objectArray[2]);
            }
            catch (Exception exception) {}
        }
        return;
    }

    private <T> List<T> safeCopy(EList<T> substitutionGroup) {
        while (true) {
            try {
                return new ArrayList<T>(substitutionGroup);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            break;
        }
    }

    public Document encodeAsDOM(Object object, QName name) throws IOException, SAXException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(object, name, out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DOMResult result = new DOMResult();
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.transform(new StreamSource(in), result);
        return (Document)result.getNode();
    }

    public String encodeAsString(Object object, QName name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(object, name, out);
        return new String(out.toByteArray());
    }

    protected void closeIterator(Iterator iterator, Object source) {
        DataUtilities.close(iterator);
    }

    protected Node encode(Object object, XSDNamedComponent component) {
        return this.encode(object, component, null);
    }

    protected Node encode(Object object, XSDNamedComponent component, XSDTypeDefinition container) {
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            return this.encoder.encode(object, element, this.doc, container);
        }
        if (component instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)component;
            return this.encoder.encode(object, attribute, this.doc, container);
        }
        return null;
    }

    protected void start(Element element, XSDElementDeclaration declaration) throws SAXException {
        Node node;
        int i;
        String local;
        String uri;
        if (element.getLocalName() != null) {
            uri = element.getNamespaceURI();
            local = element.getLocalName();
        } else {
            local = element.getNodeName();
            if (local.contains(":")) {
                String[] split = local.split(":");
                local = split[1];
                uri = this.namespaces.getURI(split[0]);
            } else {
                uri = null;
            }
        }
        String qName = local;
        NamespaceSupport namespaces = this.namespaces;
        if (this.forceQualified(declaration)) {
            uri = uri != null ? uri : namespaces.getURI("");
            qName = namespaces.getPrefix(uri) + ":" + qName;
        } else {
            uri = "";
        }
        DOMAttributes atts = new DOMAttributes(element.getAttributes(), namespaces);
        this.serializer.startElement(uri, local, qName, atts);
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Text)) continue;
            String data = XMLUtils.removeXMLInvalidChars((String)((Text)node).getData());
            char[] ch = data.toCharArray();
            this.serializer.characters(ch, 0, ch.length);
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            QName childName = new QName(child.getNamespaceURI(), child.getNodeName());
            XSDElementDeclaration childDecl = declaration != null ? Schemas.getChildElementDeclaration(declaration, childName) : null;
            this.start(child, childDecl);
            this.end(child, childDecl);
        }
        this.namespaces.pushContext();
        if (uri != null) {
            this.namespaces.declarePrefix("", uri);
        }
    }

    boolean forceQualified(XSDElementDeclaration e) {
        return this.namespaceAware && (e == null || e.isGlobal() || e.getSchema() == null || e.getSchema().getElementFormDefault() == XSDForm.QUALIFIED_LITERAL);
    }

    protected void comment(Element element) throws SAXException, IOException {
        if (this.serializer instanceof LexicalHandler) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node text = children.item(i);
                String str = text.getNodeValue();
                ((LexicalHandler)((Object)this.serializer)).comment(str.toCharArray(), 0, str.length());
            }
        }
    }

    protected void end(Element element, XSDElementDeclaration declaration) throws SAXException {
        this.namespaces.popContext();
        String uri = element.getNamespaceURI();
        String local = element.getLocalName();
        String qName = element.getLocalName();
        if (element.getPrefix() != null && !"".equals(element.getPrefix())) {
            qName = element.getPrefix() + ":" + qName;
        } else if (this.forceQualified(declaration)) {
            String string = uri = uri != null ? uri : this.namespaces.getURI("");
            if (uri != null) {
                qName = this.namespaces.getPrefix(uri) + ":" + qName;
            } else {
                uri = "";
            }
        }
        this.serializer.endElement(uri, local, qName);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public BindingLoader getBindingLoader() {
        return this.bindingLoader;
    }

    public PicoContainer getContext() {
        return this.context;
    }

    private static class MatchComparator
    implements Comparator<Object[]> {
        private MatchComparator() {
        }

        @Override
        public int compare(Object[] match1, Object[] match2) {
            Binding b1 = (Binding)match1[1];
            Binding b2 = (Binding)match2[1];
            if (b1.getType() != b2.getType()) {
                if (b2.getType().isAssignableFrom(b1.getType())) {
                    return -1;
                }
                if (b1.getType().isAssignableFrom(b2.getType())) {
                    return 1;
                }
            }
            if (b1 instanceof Comparable) {
                return ((Comparable)((Object)b1)).compareTo(b2);
            }
            if (b2 instanceof Comparable) {
                return -1 * ((Comparable)((Object)b2)).compareTo(b1);
            }
            return 0;
        }
    }

    private static class DOMAttributes
    implements Attributes {
        NamedNodeMap atts;
        NamespaceSupport namespaces;

        public DOMAttributes(NamedNodeMap atts, NamespaceSupport namespaces) {
            this.atts = atts;
            this.namespaces = namespaces;
        }

        @Override
        public int getLength() {
            return this.atts.getLength();
        }

        @Override
        public String getLocalName(int index) {
            int dot;
            String qName;
            String local = this.atts.item(index).getLocalName();
            if (this.nullOrEmpty(local) && !this.nullOrEmpty(qName = this.getQName(index)) && (dot = qName.indexOf(58)) > -1) {
                local = qName.split(":")[1];
            }
            return this.emptyIfNull(local);
        }

        @Override
        public String getQName(int index) {
            Node n = this.atts.item(index);
            if (this.namespaces != null) {
                String prefix;
                String uri = n.getNamespaceURI();
                String string = prefix = uri != null ? this.namespaces.getPrefix(uri) : null;
                if (prefix != null) {
                    return prefix + ":" + n.getLocalName();
                }
            }
            return n.getLocalName() != null ? n.getLocalName() : n.getNodeName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            String ns = this.atts.item(index).getNamespaceURI();
            if (ns == null) {
                ns = XMLUtils.qName((String)this.getQName(index), (NamespaceSupport)this.namespaces).getNamespaceURI();
            }
            return this.emptyIfNull(ns);
        }

        @Override
        public String getValue(int index) {
            return this.atts.item(index).getNodeValue();
        }

        @Override
        public int getIndex(String qName) {
            String pre = null;
            String local = null;
            if (qName.lastIndexOf(58) != -1) {
                String[] split = qName.split(":");
                pre = split[0];
                local = split[1];
            } else {
                pre = "";
                local = qName;
            }
            for (int i = 0; i < this.atts.getLength(); ++i) {
                Node att = this.atts.item(i);
                if (!att.getLocalName().equals(local)) continue;
                String apre = att.getPrefix();
                if (apre == null) {
                    apre = "";
                }
                if (!pre.equals(apre)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        @Override
        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (uri == null || uri.equals("")) {
                return this.getIndex(localName);
            }
            return this.getIndex(uri + ":" + localName);
        }

        @Override
        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        boolean nullOrEmpty(String val) {
            return val == null || "".equals(val);
        }

        String emptyIfNull(String val) {
            return val != null ? val : "";
        }
    }

    private static class EncodingEntry {
        public Object object;
        public XSDElementDeclaration element;
        public Element encoding;
        public List<Object[]> children;
        public EncodingEntry parent;

        public EncodingEntry(Object object, XSDElementDeclaration element, EncodingEntry parent) {
            this.object = object;
            this.element = element;
            this.parent = parent;
            this.children = new ArrayList<Object[]>();
        }
    }

    private static class SingleIterator
    implements Iterator {
        Object object;
        boolean more;

        public SingleIterator(Object object) {
            this.object = object;
            this.more = true;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        public Object next() {
            this.more = false;
            return this.object;
        }
    }

    private static class NullIterator
    implements Iterator {
        private NullIterator() {
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    }
}

