/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.SchemaLocationResolver;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.geotools.xsd.impl.TypeWalker;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Schemas {
    private static final Logger LOGGER = Logging.getLogger(Schemas.class);
    static final String FORCE_SCHEMA_IMPORT = "org.geotools.xml.forceSchemaImport";

    public static final SchemaIndex findSchemas(Configuration configuration) {
        HashSet<Configuration> configurations = new HashSet<Configuration>(configuration.allDependencies());
        configurations.add(configuration);
        ArrayList<XSDSchema> resolvedSchemas = new ArrayList<XSDSchema>(configurations.size());
        for (Configuration conf : configurations) {
            XSDSchema schema;
            SchemaLocator locator;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("looking up schema for " + conf.getNamespaceURI());
            }
            if ((locator = new SchemaLocator(conf.getXSD())) == null) {
                LOGGER.fine("No schema locator for " + conf.getNamespaceURI());
                continue;
            }
            String namespaceURI = conf.getNamespaceURI();
            String schemaLocation = null;
            try {
                URL location = new URL(conf.getXSD().getSchemaLocation());
                schemaLocation = location.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("schema location: " + schemaLocation);
            }
            if ((schema = locator.locateSchema(null, namespaceURI, schemaLocation, null)) == null) continue;
            resolvedSchemas.add(schema);
        }
        XSDSchema[] schemas = resolvedSchemas.toArray(new XSDSchema[resolvedSchemas.size()]);
        SchemaIndexImpl index = new SchemaIndexImpl(schemas);
        return index;
    }

    public static List<XSDSchemaLocationResolver> findSchemaLocationResolvers(Configuration configuration) {
        List<Configuration> all = configuration.allDependencies();
        ArrayList<XSDSchemaLocationResolver> resolvers = new ArrayList<XSDSchemaLocationResolver>();
        for (Configuration c : all) {
            SchemaLocationResolver resolver = new SchemaLocationResolver(c.getXSD());
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        return resolvers;
    }

    public static final XSDSchema parse(String location) throws IOException {
        return Schemas.parse(location, Collections.emptyList(), Collections.emptyList());
    }

    public static final XSDSchema parse(String location, List<XSDSchemaLocator> locators, List<XSDSchemaLocationResolver> resolvers) throws IOException {
        return Schemas.parse(location, locators, resolvers, null);
    }

    public static final XSDSchema parse(String location, List<XSDSchemaLocator> locators, List<XSDSchemaLocationResolver> resolvers, List<URIHandler> uriHandlers) throws IOException {
        AdapterFactoryImpl adapterFactory;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (resolvers != null && !resolvers.isEmpty()) {
            adapterFactory = new SchemaLocationResolverAdapterFactory(resolvers);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (locators != null && !locators.isEmpty()) {
            adapterFactory = new SchemaLocatorAdapterFactory(locators);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (uriHandlers != null && !uriHandlers.isEmpty()) {
            resourceSet.getURIConverter().getURIHandlers().addAll(0, uriHandlers);
        }
        return Schemas.parse(location, (ResourceSet)resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XSDSchema parse(String location, ResourceSet resourceSet) throws IOException {
        File locationFile = null;
        try {
            locationFile = URLs.urlToFile((URL)new URL(location));
        }
        catch (MalformedURLException e) {
            locationFile = new File(location);
        }
        if (locationFile != null && locationFile.exists()) {
            location = locationFile.getCanonicalFile().toURI().toString();
        }
        URI uri = URI.createURI((String)location);
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)".xsd"));
        xsdMainResource.setURI(uri);
        Map options = resourceSet.getLoadOptions();
        Map<?, ?> response = Schemas.getOrCreateResponseFrom(options);
        byte[] resourceData = Schemas.readUriResource(uri, resourceSet, response);
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(resourceData);){
                xsdMainResource.load((InputStream)in, options);
            }
            finally {
                Long timeStamp = (Long)response.get("TIME_STAMP");
                if (timeStamp != null) {
                    xsdMainResource.setTimeStamp(timeStamp.longValue());
                }
            }
            XSDSchema schema = xsdMainResource.getSchema();
            if (schema != null) {
                String forceSchemaImport = System.getProperty(FORCE_SCHEMA_IMPORT);
                boolean alwaysForce = false;
                if (forceSchemaImport != null) {
                    alwaysForce = forceSchemaImport.equalsIgnoreCase("true");
                }
                if (alwaysForce || Schemas.hasNoElementsNorTypes(schema)) {
                    Schemas.forceImport((XSDSchemaImpl)schema);
                }
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            return schema;
        }
    }

    private static byte[] readUriResource(URI uri, ResourceSet resourceSet, Map<?, ?> response) throws IOException {
        Map options = resourceSet.getLoadOptions();
        URIConverter uriConverter = Schemas.getUriConverter(resourceSet);
        HashMap loadMap = new HashMap(options);
        loadMap.put("RESPONSE", response);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream inputStream = uriConverter.createInputStream(uri, loadMap);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        return out.toByteArray();
    }

    private static Map<?, ?> getOrCreateResponseFrom(Map<Object, Object> options) {
        HashMap response;
        HashMap hashMap = response = options == null ? null : (HashMap)options.get("RESPONSE");
        if (response == null) {
            response = new HashMap();
        }
        return response;
    }

    private static URIConverter getUriConverter(ResourceSet resourceSet) {
        URIConverter uriConverter = resourceSet.getURIConverter();
        return uriConverter;
    }

    private static boolean hasNoElementsNorTypes(XSDSchema schema) {
        if (schema == null) {
            return false;
        }
        return schema.getElementDeclarations().isEmpty() && schema.getTypeDefinitions().isEmpty();
    }

    private static void forceImport(XSDSchemaImpl schema) {
        if (schema != null) {
            for (XSDSchemaContent content : schema.getContents()) {
                if (!(content instanceof XSDImportImpl)) continue;
                XSDImportImpl importDirective = (XSDImportImpl)content;
                schema.resolveSchema(importDirective.getNamespace());
            }
        }
    }

    public static final XSDImport importSchema(XSDSchema schema, final XSDSchema importee) throws IOException {
        Resource resource = schema.eResource();
        if (resource == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(URI.createURI((String)".xsd"));
            resource.getContents().add((Object)schema);
        }
        XSDImport imprt = XSDFactory.eINSTANCE.createXSDImport();
        imprt.setNamespace(importee.getTargetNamespace());
        schema.getContents().add((Object)imprt);
        ArrayList<XSDSchemaLocator> locators = new ArrayList<XSDSchemaLocator>();
        locators.add(new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                if (importee.getTargetNamespace().equals(namespaceURI)) {
                    return importee;
                }
                return null;
            }
        });
        SchemaLocatorAdapterFactory adapterFactory = new SchemaLocatorAdapterFactory(locators);
        resource.getResourceSet().getAdapterFactories().add((Object)adapterFactory);
        return imprt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final void dispose(XSDSchema schema) {
        Iterator iterator = schema.getContents().iterator();
        while (iterator.hasNext()) {
            XSDSchemaDirective directive;
            XSDSchema resolvedSchema;
            XSDSchemaContent content = (XSDSchemaContent)iterator.next();
            if (!(content instanceof XSDSchemaDirective) || (resolvedSchema = (directive = (XSDSchemaDirective)content).getResolvedSchema()) == null) continue;
            Class<Schemas> clazz = Schemas.class;
            // MONITORENTER : org.geotools.xsd.Schemas.class
            EList eList = resolvedSchema.eAdapters();
            // MONITORENTER : eList
            resolvedSchema.getReferencingDirectives().remove((Object)directive);
            for (XSDElementDeclaration dec : resolvedSchema.getElementDeclarations()) {
                if (dec == null) continue;
                ArrayList<XSDElementDeclaration> toRemove = new ArrayList<XSDElementDeclaration>();
                for (XSDElementDeclaration subs : dec.getSubstitutionGroup()) {
                    if (subs == null || subs.getContainer() == null || !subs.getContainer().equals(schema)) continue;
                    toRemove.add(subs);
                }
                dec.getSubstitutionGroup().removeAll(toRemove);
            }
            // MONITOREXIT : eList
            // MONITOREXIT : clazz
        }
    }

    public static final List validateImportsIncludes(String location) throws IOException {
        return Schemas.validateImportsIncludes(location, Collections.emptyList(), Collections.emptyList());
    }

    public static final List validateImportsIncludes(String location, XSDSchemaLocator[] locators, XSDSchemaLocationResolver[] resolvers) throws IOException {
        return Schemas.validateImportsIncludes(location, locators != null ? Arrays.asList(locators) : Collections.emptyList(), resolvers != null ? Arrays.asList(resolvers) : Collections.emptyList());
    }

    public static final List validateImportsIncludes(String location, List<XSDSchemaLocator> locators, List<XSDSchemaLocationResolver> resolvers) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw (IOException)new IOException("could not create parser").initCause(e);
        }
        SchemaImportIncludeValidator validator = new SchemaImportIncludeValidator(locators, resolvers);
        LinkedList<String> q = new LinkedList<String>();
        q.add(location);
        while (!q.isEmpty()) {
            location = (String)q.removeFirst();
            validator.setBaseLocation(location);
            try {
                parser.parse(location, (DefaultHandler)validator);
            }
            catch (SAXException e) {
                throw (IOException)new IOException("parse error").initCause(e);
            }
            if (!validator.errors.isEmpty()) {
                return validator.errors;
            }
            if (validator.next.isEmpty()) continue;
            q.addAll(validator.next);
        }
        return Collections.emptyList();
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type) {
        return Schemas.getChildElementDeclarations(type, true);
    }

    public static final XSDParticle getChildElementParticle(XSDTypeDefinition type, String name, boolean includeParents) {
        List<XSDParticle> particles = Schemas.getChildElementParticles(type, includeParents);
        for (XSDParticle o : particles) {
            XSDParticle particle = o;
            XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
            if (element.isElementDeclarationReference()) {
                element.getResolvedElementDeclaration();
            }
            if (!name.equals(element.getName())) continue;
            return particle;
        }
        return null;
    }

    public static final List<XSDParticle> getChildElementParticles(XSDTypeDefinition type, boolean includeParents) {
        final HashSet contents = new HashSet();
        final ArrayList particles = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(){

                    @Override
                    public void visit(XSDParticle particle) {
                        XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                        if (element.isElementDeclarationReference()) {
                            element = element.getResolvedElementDeclaration();
                        }
                        if (!contents.contains(element)) {
                            contents.add(element);
                            particles.add(particle);
                        }
                    }
                };
                Schemas.visitElements(cType, visitor);
                return true;
            }
        };
        if (includeParents) {
            new TypeWalker().rwalk(type, visitor);
        } else {
            visitor.visit(type);
        }
        return new ArrayList<XSDParticle>(particles);
    }

    public static final List<XSDParticle> getAnyElementParticles(XSDTypeDefinition type) {
        final HashSet contents = new HashSet();
        final ArrayList particles = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(){

                    @Override
                    public void visit(XSDParticle particle) {
                        XSDWildcard element = (XSDWildcard)particle.getContent();
                        if (!contents.contains(element)) {
                            contents.add(element);
                            particles.add(particle);
                        }
                    }
                };
                Schemas.visitAnyElements(cType, visitor);
                return true;
            }
        };
        visitor.visit(type);
        return new ArrayList<XSDParticle>(particles);
    }

    private static void visitAnyElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast((XSDParticle)cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 2) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            if (parts.isEmpty()) {
                parts = grp.getContents();
            }
            for (int i = parts.size() - 1; i >= 0; --i) {
                queue.addFirst(parts.get(i));
            }
        }
    }

    public static final List<XSDElementDeclaration> getChildElementDeclarations(XSDTypeDefinition type, boolean includeParents) {
        List<XSDParticle> particles = Schemas.getChildElementParticles(type, includeParents);
        ArrayList<XSDElementDeclaration> elements = new ArrayList<XSDElementDeclaration>();
        for (XSDParticle particle : particles) {
            XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
            if (decl.isElementDeclarationReference()) {
                decl = decl.getResolvedElementDeclaration();
            }
            elements.add(decl);
        }
        return elements;
    }

    public static final XSDTypeDefinition getBaseTypeDefinition(XSDTypeDefinition type, final QName parentTypeName) {
        final ArrayList found = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (Schemas.nameMatches((XSDNamedComponent)type, parentTypeName)) {
                    found.add(type);
                    return false;
                }
                return true;
            }
        };
        new TypeWalker().walk(type, visitor);
        return found.isEmpty() ? null : (XSDTypeDefinition)found.get(0);
    }

    public static final boolean isBaseType(XSDElementDeclaration e1, XSDElementDeclaration e2) {
        for (XSDTypeDefinition type = e1.getType(); type != null; type = type.getBaseType()) {
            if (type.equals(e2.getType())) {
                return true;
            }
            if (type.equals(type.getBaseType())) break;
        }
        return false;
    }

    public static final int getMinOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList minOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            @Override
            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    if (particle.isSetMinOccurs()) {
                        minOccurs.add(particle.getMinOccurs());
                    } else if (particle.getContainer() instanceof XSDModelGroup && particle.getContainer().getContainer() instanceof XSDParticle) {
                        particle = (XSDParticle)particle.getContainer().getContainer();
                        minOccurs.add(particle.getMinOccurs());
                    } else {
                        minOccurs.add(1);
                    }
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (minOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)minOccurs.get(0);
    }

    public static final int getMaxOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList maxOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            @Override
            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    if (particle.isSetMaxOccurs()) {
                        maxOccurs.add(particle.getMaxOccurs());
                    } else if (particle.getContainer() instanceof XSDModelGroup && particle.getContainer().getContainer() instanceof XSDParticle) {
                        particle = (XSDParticle)particle.getContainer().getContainer();
                        maxOccurs.add(particle.getMaxOccurs());
                    } else {
                        maxOccurs.add(1);
                    }
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (maxOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)maxOccurs.get(0);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor, boolean includeParents) {
        if (includeParents) {
            LinkedList<XSDComplexTypeDefinition> baseTypes = new LinkedList<XSDComplexTypeDefinition>();
            for (XSDTypeDefinition baseType = cType.getBaseType(); baseType != null && baseType != baseType.getBaseType(); baseType = baseType.getBaseType()) {
                if (!(baseType instanceof XSDComplexTypeDefinition)) continue;
                baseTypes.addLast((XSDComplexTypeDefinition)baseType);
            }
            for (XSDComplexTypeDefinition td : baseTypes) {
                Schemas.visitElements(td, visitor);
            }
        }
        Schemas.visitElements(cType, visitor);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast((XSDParticle)cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 11) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            if (parts.isEmpty()) {
                parts = grp.getContents();
            }
            for (int i = parts.size() - 1; i >= 0; --i) {
                queue.addFirst(parts.get(i));
            }
        }
    }

    public static final XSDElementDeclaration getChildElementDeclaration(XSDElementDeclaration parent, QName qName) {
        List children = Schemas.getChildElementDeclarations(parent.getType());
        for (Object value : children) {
            XSDElementDeclaration element = (XSDElementDeclaration)value;
            if (!Schemas.nameMatches((XSDNamedComponent)element, qName)) continue;
            return element;
        }
        ArrayList<XSDElementDeclaration> derived = new ArrayList<XSDElementDeclaration>();
        for (Object o : children) {
            XSDElementDeclaration child = (XSDElementDeclaration)o;
            derived.addAll(Schemas.getDerivedElementDeclarations(child));
        }
        for (XSDElementDeclaration child : derived) {
            if (!Schemas.nameMatches((XSDNamedComponent)child, qName)) continue;
            return child;
        }
        return null;
    }

    public static final List<XSDElementDeclaration> getDerivedElementDeclarations(XSDElementDeclaration element) {
        EList elements = element.getSchema().getElementDeclarations();
        ArrayList<XSDElementDeclaration> derived = new ArrayList<XSDElementDeclaration>();
        block0: for (XSDElementDeclaration derivee : elements) {
            if (derivee.equals(element)) continue;
            XSDTypeDefinition type = derivee.getType();
            while (true) {
                if (type.equals(element.getType())) {
                    derived.add(derivee);
                    continue block0;
                }
                if (type.equals(type.getBaseType())) continue block0;
                type = type.getBaseType();
            }
        }
        return derived;
    }

    public static final List<XSDAttributeDeclaration> getAttributeDeclarations(XSDElementDeclaration element) {
        return Schemas.getAttributeDeclarations(element.getType());
    }

    public static final List<XSDAttributeDeclaration> getAttributeDeclarations(XSDTypeDefinition type) {
        return Schemas.getAttributeDeclarations(type, true);
    }

    public static final List<XSDAttributeDeclaration> getAttributeDeclarations(XSDTypeDefinition type, boolean includeParents) {
        final ArrayList<XSDAttributeDeclaration> attributes = new ArrayList<XSDAttributeDeclaration>();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            @Override
            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                EList attContent = cType.getAttributeContents();
                for (Object value : attContent) {
                    XSDAttributeGroupContent content = (XSDAttributeGroupContent)value;
                    if (content instanceof XSDAttributeUse) {
                        XSDAttributeUse use = (XSDAttributeUse)content;
                        attributes.add(use.getAttributeDeclaration());
                        continue;
                    }
                    if (!(content instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition attGrp = (XSDAttributeGroupDefinition)content;
                    if (attGrp.isAttributeGroupDefinitionReference()) {
                        attGrp = attGrp.getResolvedAttributeGroupDefinition();
                    }
                    EList uses = attGrp.getAttributeUses();
                    for (Object o : uses) {
                        XSDAttributeUse use = (XSDAttributeUse)o;
                        attributes.add(use.getAttributeDeclaration());
                    }
                }
                return true;
            }
        };
        if (includeParents) {
            new TypeWalker().walk(type, visitor);
        } else {
            visitor.visit(type);
        }
        return attributes;
    }

    public static final XSDAttributeDeclaration getAttributeDeclaration(XSDElementDeclaration element, QName qName) {
        List<XSDAttributeDeclaration> atts = Schemas.getAttributeDeclarations(element);
        for (XSDAttributeDeclaration o : atts) {
            XSDAttributeDeclaration att = o;
            if (!Schemas.nameMatches((XSDNamedComponent)att, qName)) continue;
            return att;
        }
        return null;
    }

    public static final List getImports(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDImport> imports = new ArrayList<XSDImport>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            for (Object o : contents) {
                XSDImport imprt;
                XSDSchemaContent content = (XSDSchemaContent)o;
                if (!(content instanceof XSDImport) || added.contains((imprt = (XSDImport)content).getNamespace())) continue;
                imports.add(imprt);
                added.add(imprt.getNamespace());
                XSDSchema resolvedSchema = imprt.getResolvedSchema();
                if (resolvedSchema == null) {
                    LOGGER.info("Schema import wasn't resolved: " + imprt.getNamespace() + " declared location: " + imprt.getSchemaLocation());
                    continue;
                }
                queue.addLast(resolvedSchema);
            }
        }
        return imports;
    }

    public static final List getIncludes(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDInclude> includes = new ArrayList<XSDInclude>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            for (Object o : contents) {
                XSDInclude include;
                XSDSchemaContent content = (XSDSchemaContent)o;
                if (!(content instanceof XSDInclude) || added.contains((include = (XSDInclude)content).getSchemaLocation())) continue;
                includes.add(include);
                added.add(include.getSchemaLocation());
                if (include.getIncorporatedSchema() != null) {
                    queue.addLast(include.getIncorporatedSchema());
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("include: " + include + " resulted in null schema");
            }
        }
        return includes;
    }

    public static XSDElementDeclaration getElementDeclaration(XSDSchema schema, QName name) {
        for (XSDElementDeclaration element : schema.getElementDeclarations()) {
            if (!element.getTargetNamespace().equals(name.getNamespaceURI()) || !element.getName().equals(name.getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public static final boolean nameMatches(XSDNamedComponent component, QName qName) {
        String ns1 = component.getTargetNamespace();
        String ns2 = qName.getNamespaceURI();
        String n1 = component.getName();
        String n2 = qName.getLocalPart();
        ns1 = "".equals(ns1) ? null : ns1;
        ns2 = "".equals(ns2) ? null : ns2;
        n1 = "".equals(n1) ? null : n1;
        String string = n2 = "".equals(n2) ? null : n2;
        if (ns1 == null && ns2 != null && component.getSchema() != null && "".equals(ns1 = component.getSchema().getTargetNamespace())) {
            ns1 = null;
        }
        return Utilities.equals((Object)ns1, (Object)ns2) && Utilities.equals((Object)n1, (Object)n2);
    }

    public static String getTargetPrefix(XSDSchema schema) {
        String ns = schema.getTargetNamespace();
        Map pre2ns = schema.getQNamePrefixToNamespaceMap();
        for (Map.Entry o : pre2ns.entrySet()) {
            Map.Entry entry = o;
            if (entry.getKey() == null || !entry.getValue().equals(ns)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static <T> List<T> getComponentInstancesOfType(PicoContainer container, Class<T> clazz) {
        ArrayList instances = new ArrayList();
        while (container != null) {
            List l = container.getComponentInstancesOfType(clazz);
            instances.addAll(l);
            container = container.getParent();
        }
        return instances;
    }

    public static List<ComponentAdapter> getComponentAdaptersOfType(PicoContainer container, Class clazz) {
        ArrayList<ComponentAdapter> instances = new ArrayList<ComponentAdapter>();
        while (container != null) {
            List l = container.getComponentAdaptersOfType(clazz);
            instances.addAll(l);
            container = container.getParent();
        }
        return instances;
    }

    public static void unregisterComponent(PicoContainer container, final Object key) {
        while (container.getParent() != null) {
            container = container.getParent();
        }
        container.accept(new PicoVisitor(){

            public Object traverse(Object node) {
                return null;
            }

            public void visitContainer(PicoContainer container) {
                if (container instanceof MutablePicoContainer) {
                    ((MutablePicoContainer)container).unregisterComponent(key);
                }
            }

            public void visitComponentAdapter(ComponentAdapter adapter) {
            }

            public void visitParameter(Parameter parameter) {
            }
        });
    }

    public static QName getParticleName(XSDParticle particle) {
        XSDElementDeclaration content = (XSDElementDeclaration)particle.getContent();
        if (content.isElementDeclarationReference()) {
            content = content.getResolvedElementDeclaration();
        }
        return new QName(content.getTargetNamespace(), content.getName());
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    static class SchemaLocationResolverAdapter
    extends AdapterImpl
    implements XSDSchemaLocationResolver {
        List<XSDSchemaLocationResolver> resolvers;

        public SchemaLocationResolverAdapter(List<XSDSchemaLocationResolver> resolvers) {
            this.resolvers = new ArrayList<XSDSchemaLocationResolver>(resolvers);
        }

        public boolean isAdapterForType(Object type) {
            return type == XSDSchemaLocationResolver.class;
        }

        public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI) {
            for (XSDSchemaLocationResolver resolver : this.resolvers) {
                String resolved = resolver.resolveSchemaLocation(schema, namespaceURI, rawSchemaLocationURI);
                if (resolved == null) continue;
                return resolved;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not resolve schema location: " + rawSchemaLocationURI + " to physical location.");
            }
            return null;
        }
    }

    static class SchemaLocationResolverAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocationResolverAdapter adapter;

        public SchemaLocationResolverAdapterFactory(List<XSDSchemaLocationResolver> resolvers) {
            this.adapter = new SchemaLocationResolverAdapter(resolvers);
        }

        public boolean isFactoryForType(Object type) {
            return type == XSDSchemaLocationResolver.class;
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    static class SchemaLocatorAdapter
    extends AdapterImpl
    implements XSDSchemaLocator {
        List<XSDSchemaLocator> locators;

        public SchemaLocatorAdapter(List<XSDSchemaLocator> locators) {
            this.locators = new ArrayList<XSDSchemaLocator>(locators);
        }

        public boolean isAdapterForType(Object type) {
            return type == XSDSchemaLocator.class;
        }

        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
            for (XSDSchemaLocator locator : this.locators) {
                XSDSchema schema = locator.locateSchema(xsdSchema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocationURI);
                if (schema == null) continue;
                return schema;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not locate schema for: " + rawSchemaLocationURI + ".");
            }
            return null;
        }
    }

    static class SchemaLocatorAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocatorAdapter adapter;

        public SchemaLocatorAdapterFactory(List<XSDSchemaLocator> locators) {
            this.adapter = new SchemaLocatorAdapter(locators);
        }

        public boolean isFactoryForType(Object type) {
            return type == XSDSchemaLocator.class;
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    private static interface ElementVisitor {
        public void visit(XSDParticle var1);
    }

    static final class SchemaImportIncludeValidator
    extends DefaultHandler {
        String baseLocation;
        List<XSDSchemaLocator> locators;
        List<XSDSchemaLocationResolver> resolvers;
        Set<String> seen;
        List<String> errors;
        List<String> next;

        SchemaImportIncludeValidator(List<XSDSchemaLocator> locators, List<XSDSchemaLocationResolver> resolvers) {
            this.locators = locators;
            this.resolvers = resolvers;
            this.seen = new HashSet<String>();
            this.errors = new ArrayList<String>();
            this.next = new ArrayList<String>();
        }

        public void setBaseLocation(String baseLocation) {
            this.baseLocation = baseLocation;
        }

        @Override
        public void startDocument() throws SAXException {
            this.next.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("import".equals(localName)) {
                String namespace = attributes.getValue("namespace");
                String schemaLocation = attributes.getValue("schemaLocation");
                if (this.seen.contains(namespace)) {
                    return;
                }
                this.seen.add(namespace);
                if (schemaLocation != null) {
                    for (XSDSchemaLocator locator : this.locators) {
                        if (!(locator instanceof SchemaLocator) || !((SchemaLocator)locator).canHandle(null, namespace, schemaLocation, null)) continue;
                        return;
                    }
                    String resolvedSchemaLocation = this.resolve(namespace, schemaLocation);
                    if (resolvedSchemaLocation != null) {
                        this.recurse(resolvedSchemaLocation);
                    } else {
                        this.errors.add("Could not resolve import: " + namespace + "," + schemaLocation);
                    }
                } else {
                    this.errors.add("No schemaLocation attribute for namespace import: " + namespace);
                }
            } else if ("include".equals(localName)) {
                String location = attributes.getValue("location");
                String resolvedLocation = this.resolve(null, location);
                if (resolvedLocation != null) {
                    this.recurse(resolvedLocation);
                } else {
                    this.errors.add("Could not resolve include: " + location);
                }
            }
        }

        String resolve(String namespace, String location) {
            File dir;
            for (XSDSchemaLocationResolver resolver : this.resolvers) {
                String resolvedSchemaLocation;
                if (!(resolver instanceof SchemaLocationResolver) || !((SchemaLocationResolver)resolver).canHandle(null, namespace, location) || (resolvedSchemaLocation = resolver.resolveSchemaLocation(null, namespace, location)) == null) continue;
                return resolvedSchemaLocation;
            }
            File file = new File(location);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!file.isAbsolute() && (dir = new File(this.baseLocation).getParentFile()) != null && (file = new File(dir, location)).exists()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        void recurse(String location) {
            if (this.seen.contains(location)) {
                return;
            }
            this.seen.add(location);
            this.next.add(location);
        }
    }
}

