/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter.data;

import com.itextpdf.io.util.SystemUtil;
import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.IEventDataCache;
import com.itextpdf.kernel.counter.data.IEventDataFactory;
import com.itextpdf.kernel.counter.data.WaitTime;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class EventDataHandler<T, V extends EventData<T>> {
    private final Object createLock = new Object();
    private final Object processLock = new Object();
    private final IEventDataCache<T, V> cache;
    private final IEventDataFactory<T, V> factory;
    private final AtomicLong lastProcessedTime = new AtomicLong();
    private volatile WaitTime waitTime;

    public EventDataHandler(IEventDataCache<T, V> cache, IEventDataFactory<T, V> factory, long initialWaitTimeMillis, long maxWaitTimeMillis) {
        this.cache = cache;
        this.factory = factory;
        this.waitTime = new WaitTime(initialWaitTimeMillis, maxWaitTimeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> clear() {
        List<V> all;
        IEventDataCache<T, V> iEventDataCache = this.cache;
        synchronized (iEventDataCache) {
            all = this.cache.clear();
        }
        this.lastProcessedTime.set(0L);
        this.resetWaitTime();
        return all != null ? all : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IEvent event, IMetaInfo metaInfo) {
        V data;
        IEventDataCache<T, V> iEventDataCache = this.createLock;
        synchronized (iEventDataCache) {
            data = this.factory.create(event, metaInfo);
        }
        if (data != null) {
            iEventDataCache = this.cache;
            synchronized (iEventDataCache) {
                this.cache.put(data);
            }
            this.tryProcessNextAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryProcessNext() {
        long currentTime = SystemUtil.getRelativeTimeMillis();
        if (currentTime - this.lastProcessedTime.get() > this.waitTime.getTime()) {
            V data;
            this.lastProcessedTime.set(SystemUtil.getRelativeTimeMillis());
            IEventDataCache<T, V> iEventDataCache = this.cache;
            synchronized (iEventDataCache) {
                data = this.cache.retrieveNext();
            }
            if (data != null) {
                boolean successful;
                IEventDataCache<T, V> iEventDataCache2 = this.processLock;
                synchronized (iEventDataCache2) {
                    successful = this.tryProcess(data);
                }
                if (successful) {
                    this.onSuccess(data);
                } else {
                    iEventDataCache2 = this.cache;
                    synchronized (iEventDataCache2) {
                        this.cache.put(data);
                    }
                    this.onFailure(data);
                }
            }
        }
    }

    public void tryProcessNextAsync() {
        this.tryProcessNextAsync(null);
    }

    public void tryProcessNextAsync(Boolean daemon) {
        long currentTime = SystemUtil.getRelativeTimeMillis();
        if (currentTime - this.lastProcessedTime.get() > this.waitTime.getTime()) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    EventDataHandler.this.tryProcessNext();
                }
            };
            if (daemon != null) {
                thread.setDaemon(daemon);
            }
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryProcessRest() {
        List<V> unprocessedEvents = this.clear();
        if (!unprocessedEvents.isEmpty()) {
            try {
                Object object = this.processLock;
                synchronized (object) {
                    for (EventData data : unprocessedEvents) {
                        this.process(data);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetWaitTime() {
        WaitTime local = this.waitTime;
        this.waitTime = new WaitTime(local.getInitial(), local.getMaximum());
    }

    public void increaseWaitTime() {
        WaitTime local = this.waitTime;
        this.waitTime = new WaitTime(local.getInitial(), local.getMaximum(), Math.min(local.getTime() * 2L, local.getMaximum()));
    }

    public void setNoWaitTime() {
        WaitTime local = this.waitTime;
        this.waitTime = new WaitTime(local.getInitial(), local.getMaximum(), 0L);
    }

    public WaitTime getWaitTime() {
        return this.waitTime;
    }

    protected void onSuccess(V data) {
        this.resetWaitTime();
    }

    protected void onFailure(V data) {
        this.increaseWaitTime();
    }

    protected boolean onProcessException(Exception exception) {
        return false;
    }

    protected abstract boolean process(V var1);

    private boolean tryProcess(V data) {
        try {
            return this.process(data);
        }
        catch (Exception any) {
            return this.onProcessException(any);
        }
    }
}

