/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.data.oracle.filter.FilterFunction_sdonn;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_area;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class OracleFilterToSQL
extends PreparedFilterToSQL {
    private static final Map<Class<?>, String> SDO_RELATE_MASK_MAP = new HashMap<Class<?>, String>(){
        {
            this.put(Contains.class, "contains");
            this.put(Crosses.class, "overlapbdydisjoint");
            this.put(Equals.class, "equal");
            this.put(Overlaps.class, "overlapbdyintersect");
            this.put(Touches.class, "touch");
            this.put(Within.class, "inside");
            this.put(Disjoint.class, "disjoint");
            this.put(BBOX.class, "anyinteract");
            this.put(Intersects.class, "anyinteract");
        }
    };
    private static final Envelope WORLD = new Envelope(-179.99, 179.99, -89.99, 89.99);
    private static final Map<String, String> INVERSE_OPERATOR_MAP = new HashMap<String, String>(){
        {
            this.put("contains", "inside");
            this.put("inside", "contains");
            this.put("overlapbdydisjoint", "overlapbdydisjoint");
            this.put("overlapbdyintersect", "overlapbdyintersect");
            this.put("touch", "touch");
            this.put("equal", "equal");
            this.put("anyinteract", "anyinteract");
            this.put("disjoint", "disjoint");
        }
    };
    protected boolean looseBBOXEnabled;
    private static final Map<String, String> UNITS_MAP = new HashMap<String, String>(){
        {
            this.put("metre", "m");
            this.put("meters", "m");
            this.put("kilometers", "km");
            this.put("mi", "Mile");
            this.put("miles", "Mile");
            this.put("NM", "naut_mile");
            this.put("feet", "foot");
            this.put("ft", "foot");
            this.put("in", "inch");
        }
    };

    public OracleFilterToSQL(PreparedStatementSQLDialect dialect) {
        super(dialect);
        this.setSqlNameEscape("\"");
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(FilterFunction_sdonn.class);
        caps.addType(FilterFunction_area.class);
        caps.addType(After.class);
        caps.addType(Before.class);
        caps.addType(Begins.class);
        caps.addType(BegunBy.class);
        caps.addType(During.class);
        caps.addType(TOverlaps.class);
        caps.addType(Ends.class);
        caps.addType(EndedBy.class);
        caps.addType(TEquals.class);
        return caps;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        FilterFunction_sdonn sdoNnQuery = this.getSDO_NN_Query(filter);
        if (sdoNnQuery != null) {
            return this.visit(sdoNnQuery, extraData);
        }
        return super.visit(filter, extraData);
    }

    private FilterFunction_sdonn getSDO_NN_Query(PropertyIsEqualTo filter) {
        Expression expr1 = filter.getExpression1();
        Expression expr2 = filter.getExpression2();
        if (expr2 instanceof FilterFunction_sdonn) {
            Expression tmp = expr1;
            expr1 = expr2;
            expr2 = tmp;
        }
        if (expr1 instanceof FilterFunction_sdonn) {
            if (!(expr2 instanceof Literal)) {
                throw new UnsupportedOperationException("Unsupported usage of SDO_NN Oracle function: it can be compared only to a Boolean \"true\" value");
            }
            Boolean nearest = (Boolean)this.evaluateLiteral((Literal)expr2, Boolean.class);
            if (nearest == null || !nearest.booleanValue()) {
                throw new UnsupportedOperationException("Unsupported usage of SDO_NN Oracle function: it can be compared only to a Boolean \"true\" value");
            }
            return (FilterFunction_sdonn)expr1;
        }
        return null;
    }

    public Object visit(Function function, Object extraData) {
        if (function instanceof FilterFunction_sdonn) {
            throw new UnsupportedOperationException("Unsupported usage of SDO_NN Oracle function: must be used in a Equals Filter");
        }
        if (function instanceof FilterFunction_area) {
            try {
                Expression s1 = this.getParameter(function, 0, true);
                this.out.write("SDO_GEOM.SDO_AREA(");
                s1.accept((ExpressionVisitor)this, String.class);
                this.out.write(",0.05)");
                return extraData;
            }
            catch (IOException ioe) {
                throw new RuntimeException("io problem writing filter", ioe);
            }
        }
        return super.visit(function, extraData);
    }

    private String getPrimaryKeyColumnsAsCommaSeparatedList(List<PrimaryKeyColumn> pkColumns) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (PrimaryKeyColumn c : pkColumns) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            this.dialect.encodeColumnName(null, c.getName(), sb);
        }
        return sb.toString();
    }

    private Object visit(FilterFunction_sdonn sdoNnQuery, Object extraData) {
        Expression geometryExp = this.getParameter(sdoNnQuery, 0, true);
        Expression sdoNumResExp = this.getParameter(sdoNnQuery, 1, true);
        Expression cqlLiteralExp = this.getParameter(sdoNnQuery, 2, false);
        Expression sdoBatchSizeExp = this.getParameter(sdoNnQuery, 3, false);
        try {
            List pkColumns = this.getPrimaryKey().getColumns();
            if (pkColumns == null || pkColumns.isEmpty()) {
                throw new UnsupportedOperationException("Unsupported usage of SDO_NN Oracle function: table with no primary key");
            }
            String pkColumnsAsString = this.getPrimaryKeyColumnsAsCommaSeparatedList(pkColumns);
            StringBuffer sb = new StringBuffer();
            sb.append(" (").append(pkColumnsAsString).append(")").append(" in (select ").append(pkColumnsAsString).append(" from ");
            if (this.getDatabaseSchema() != null) {
                this.dialect.encodeSchemaName(this.getDatabaseSchema(), sb);
                sb.append(".");
            }
            this.dialect.encodeTableName(this.getPrimaryKey().getTableName(), sb);
            sb.append(" where SDO_NN(");
            this.dialect.encodeColumnName(null, this.featureType.getGeometryDescriptor().getLocalName(), sb);
            sb.append(",");
            Geometry geomValue = (Geometry)this.evaluateLiteral((Literal)geometryExp, Geometry.class);
            sb.append("?");
            this.literalValues.add(this.clipToWorldFeatureTypeGeometry(geomValue));
            this.descriptors.add(null);
            this.literalTypes.add(Geometry.class);
            this.SRIDs.add(this.getFeatureTypeGeometrySRID());
            this.dimensions.add(this.getFeatureTypeGeometryDimension());
            int sdo_num_res = this.getIntFromLiteral((Literal)sdoNumResExp);
            if (sdoBatchSizeExp != null) {
                int sdo_batch_size = this.getIntFromLiteral((Literal)sdoBatchSizeExp);
                sb.append(",'sdo_batch_size=" + sdo_batch_size + "'");
            } else if (cqlLiteralExp == null) {
                sb.append(",'sdo_num_res=" + sdo_num_res + "'");
            }
            sb.append(") = 'TRUE' ");
            if (cqlLiteralExp != null) {
                try {
                    sb.append("AND ");
                    this.out.write(sb.toString());
                    sb.setLength(0);
                    Filter cqlExp = CQL.toFilter((String)this.evaluateLiteral((Literal)cqlLiteralExp, String.class));
                    cqlExp.accept((FilterVisitor)this, extraData);
                }
                catch (CQLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (sdoBatchSizeExp != null || cqlLiteralExp != null) {
                sb.append(" AND ROWNUM <= " + sdo_num_res);
            }
            sb.append(")");
            this.out.write(sb.toString());
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
        return extraData;
    }

    private int getIntFromLiteral(Literal literal) {
        return ((Number)this.evaluateLiteral(literal, Number.class)).intValue();
    }

    private Geometry clipToWorldFeatureTypeGeometry(Geometry geom) {
        Geometry result;
        if (this.isFeatureTypeGeometryGeodetic() && !WORLD.contains(geom.getEnvelopeInternal()) && (result = geom.intersection((Geometry)JTS.toGeometry(WORLD))) != null && !result.isEmpty()) {
            if (result instanceof GeometryCollection) {
                result = this.distillSameTypeGeometries((GeometryCollection)result, geom);
            }
            return result;
        }
        return geom;
    }

    private Integer getFeatureTypeGeometrySRID() {
        return (Integer)this.featureType.getGeometryDescriptor().getUserData().get("nativeSRID");
    }

    private Integer getFeatureTypeGeometryDimension() {
        GeometryDescriptor descriptor = this.featureType.getGeometryDescriptor();
        return (Integer)descriptor.getUserData().get(Hints.COORDINATE_DIMENSION);
    }

    private boolean isFeatureTypeGeometryGeodetic() {
        Boolean geodetic = (Boolean)this.featureType.getGeometryDescriptor().getUserData().get("geodetic");
        return geodetic != null && geodetic != false;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            e1 = this.clipToWorld(filter, e1);
            e2 = this.clipToWorld(filter, e2);
            if (filter instanceof Beyond || filter instanceof DWithin) {
                this.doSDODistance(filter, e1, e2, extraData);
            } else if (filter instanceof BBOX && this.looseBBOXEnabled) {
                this.doSDOFilter((Filter)filter, e1, e2, extraData);
            } else {
                this.doSDORelate((Filter)filter, e1, e2, swapped, extraData);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
        return extraData;
    }

    Expression clipToWorld(BinarySpatialOperator filter, Expression e) {
        if (e instanceof Literal) {
            Geometry result;
            Geometry eval = (Geometry)e.evaluate((Object)filter, Geometry.class);
            if (this.dialect != null && this.isCurrentGeometryGeodetic() && !WORLD.contains(eval.getEnvelopeInternal()) && (result = eval.intersection((Geometry)JTS.toGeometry(WORLD))) != null && !result.isEmpty()) {
                if (result instanceof GeometryCollection) {
                    result = this.distillSameTypeGeometries((GeometryCollection)result, eval);
                }
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                e = ff.literal((Object)result);
            }
        }
        return e;
    }

    boolean isCurrentGeometryGeodetic() {
        if (this.currentGeometry != null) {
            Boolean geodetic = (Boolean)this.currentGeometry.getUserData().get("geodetic");
            return geodetic != null && geodetic != false;
        }
        return false;
    }

    protected Geometry distillSameTypeGeometries(GeometryCollection coll, Geometry original) {
        if (original instanceof Polygon || original instanceof MultiPolygon) {
            ArrayList polys = new ArrayList();
            this.accumulateGeometries(polys, (Geometry)coll, Polygon.class);
            return original.getFactory().createMultiPolygon(polys.toArray(new Polygon[polys.size()]));
        }
        if (original instanceof LineString || original instanceof MultiLineString) {
            ArrayList ls = new ArrayList();
            this.accumulateGeometries(ls, (Geometry)coll, LineString.class);
            return original.getFactory().createMultiLineString(ls.toArray(new LineString[ls.size()]));
        }
        if (original instanceof Point || original instanceof MultiPoint) {
            ArrayList points = new ArrayList();
            this.accumulateGeometries(points, (Geometry)coll, Point.class);
            return original.getFactory().createMultiPoint(points.toArray(new Point[points.size()]));
        }
        return original;
    }

    protected <T> void accumulateGeometries(List<T> collection, Geometry g, Class<? extends T> target) {
        if (target.isInstance(g)) {
            collection.add(target.cast(g));
        } else if (g instanceof GeometryCollection) {
            GeometryCollection coll = (GeometryCollection)g;
            for (int i = 0; i < coll.getNumGeometries(); ++i) {
                this.accumulateGeometries(collection, coll.getGeometryN(i), target);
            }
        }
    }

    protected void doSDOFilter(Filter filter, Expression e1, Expression e2, Object extraData) throws IOException {
        this.out.write("SDO_FILTER(");
        e1.accept((ExpressionVisitor)this, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this, extraData);
        this.out.write(", 'mask=anyinteract querytype=WINDOW') = 'TRUE' ");
    }

    protected void doSDORelate(Filter filter, Expression e1, Expression e2, boolean swapped, Object extraData) throws IOException {
        String mask = null;
        for (Class<?> filterClass : SDO_RELATE_MASK_MAP.keySet()) {
            if (!filterClass.isAssignableFrom(filter.getClass())) continue;
            mask = SDO_RELATE_MASK_MAP.get(filterClass);
        }
        if (mask == null) {
            throw new IllegalArgumentException("Cannot encode filter " + filter.getClass() + " into a SDO_RELATE");
        }
        if (swapped) {
            mask = INVERSE_OPERATOR_MAP.get(mask);
        }
        this.out.write("SDO_RELATE(");
        e1.accept((ExpressionVisitor)this, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this, extraData);
        if (filter instanceof Disjoint) {
            this.out.write(", 'mask=ANYINTERACT querytype=WINDOW') <> 'TRUE' ");
        } else {
            this.out.write(", 'mask=" + mask + " querytype=WINDOW') = 'TRUE' ");
        }
    }

    protected void doSDODistance(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) throws IOException {
        double distance = ((DistanceBufferOperator)filter).getDistance();
        String unit = OracleFilterToSQL.getSDOUnitFromOGCUnit(((DistanceBufferOperator)filter).getDistanceUnits());
        String within = filter instanceof DWithin ? "TRUE" : "FALSE";
        this.out.write("SDO_WITHIN_DISTANCE(");
        e1.accept((ExpressionVisitor)this, extraData);
        this.out.write(",");
        e2.accept((ExpressionVisitor)this, extraData);
        if (unit != null && !"".equals(unit.trim())) {
            this.out.write(",'distance=" + distance + " unit=" + unit + "') = '" + within + "' ");
        } else {
            this.out.write(",'distance=" + distance + "') = '" + within + "' ");
        }
    }

    private static String getSDOUnitFromOGCUnit(String ogcUnit) {
        String sdoUnit = UNITS_MAP.get(ogcUnit);
        return sdoUnit != null ? sdoUnit.toString() : ogcUnit;
    }

    public String escapeName(String name) {
        String sqlNameEscape = this.getSqlNameEscape();
        if (OracleDialect.reservedWords.contains(name.toUpperCase()) || !sqlNameEscape.isEmpty()) {
            int escapeOffset;
            if (sqlNameEscape.isEmpty()) {
                sqlNameEscape = "\"";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(sqlNameEscape);
            int offset = 0;
            while ((escapeOffset = name.indexOf(sqlNameEscape, offset)) != -1) {
                sb.append(name.substring(offset, escapeOffset));
                sb.append(sqlNameEscape);
                sb.append(sqlNameEscape);
                offset = escapeOffset + sqlNameEscape.length();
            }
            sb.append(name.substring(offset));
            sb.append(sqlNameEscape);
            return sb.toString();
        }
        return name;
    }
}

