/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.javasimon.utils.bean.BeanUtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);

    private ClassUtils() {
        throw new AssertionError((Object)"ClassUtils is a collections of utility methods");
    }

    static Field getField(Class<?> targetClass, String fieldName) {
        while (targetClass != null) {
            try {
                Field field = targetClass.getDeclaredField(fieldName);
                logger.debug("Found field {} in class {}", (Object)fieldName, (Object)targetClass.getName());
                return field;
            }
            catch (NoSuchFieldException e) {
                logger.debug("Failed to find field {} in class {}", (Object)fieldName, (Object)targetClass.getName());
                targetClass = targetClass.getSuperclass();
            }
        }
        return null;
    }

    static Method getSetter(Class<?> targetClass, String propertyName, Class<?> type) {
        if (targetClass == null) {
            return null;
        }
        String setterMethodName = ClassUtils.setterName(propertyName);
        try {
            Method setter = targetClass.getMethod(setterMethodName, type);
            logger.debug("Found public setter {} in class {}", (Object)setterMethodName, (Object)setter.getDeclaringClass().getName());
            return setter;
        }
        catch (NoSuchMethodException e) {
            logger.debug("Failed to found public setter {} in class {}", (Object)setterMethodName, (Object)targetClass.getName());
            while (targetClass != null) {
                try {
                    Method setter = targetClass.getDeclaredMethod(setterMethodName, type);
                    logger.debug("Found setter {} in class {}", (Object)setterMethodName, (Object)targetClass.getName());
                    return setter;
                }
                catch (NoSuchMethodException e2) {
                    logger.debug("Failed to found setter {} in class {}", (Object)setterMethodName, (Object)targetClass.getName());
                    targetClass = targetClass.getSuperclass();
                }
            }
            return null;
        }
    }

    private static String setterName(String name) {
        return "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    static Set<Method> getSetters(Class<?> targetClass, String propertyName) {
        String setterName = ClassUtils.setterName(propertyName);
        HashSet<Method> setters = new HashSet<Method>();
        while (targetClass != null) {
            for (Method method : targetClass.getDeclaredMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                logger.debug("Found setter {} in class {}", (Object)method, targetClass);
                setters.add(method);
            }
            targetClass = targetClass.getSuperclass();
        }
        return setters;
    }

    static Class<?> getSetterType(Method setter) {
        Class<?>[] parameterTypes = setter.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new BeanUtilsException(String.format("Method %s has %d parameters and cannot be a setter", setter.getName(), parameterTypes.length));
        }
        return parameterTypes[0];
    }

    static Method getGetter(Class<?> targetClass, String propertyName) {
        String booleanGetterName;
        if (targetClass == null) {
            return null;
        }
        String getterName = ClassUtils.getterName(propertyName, false);
        Method result = ClassUtils.findPublicGetter(targetClass, getterName, propertyName, false);
        if (result == null && (result = ClassUtils.findPublicGetter(targetClass, booleanGetterName = ClassUtils.getterName(propertyName, true), propertyName, true)) == null) {
            do {
                if ((result = ClassUtils.findNonPublicGetter(targetClass, getterName, propertyName, false)) != null) continue;
                result = ClassUtils.findNonPublicGetter(targetClass, booleanGetterName, propertyName, true);
            } while (result == null && (targetClass = targetClass.getSuperclass()) != null);
        }
        return result;
    }

    private static Method findPublicGetter(Class<?> targetClass, String getterName, String propertyName, boolean logError) {
        try {
            Method getter = targetClass.getMethod(getterName, new Class[0]);
            logger.debug("Found public getter {} in class {}", (Object)getter.getName(), (Object)getter.getDeclaringClass().getName());
            return getter;
        }
        catch (NoSuchMethodException e) {
            if (logError) {
                logger.debug("Failed to find public getter for property {} in class {}", (Object)propertyName, (Object)targetClass.getName());
            }
            return null;
        }
    }

    private static Method findNonPublicGetter(Class<?> targetClass, String getterName, String propertyName, boolean logError) {
        try {
            Method getter = targetClass.getDeclaredMethod(getterName, new Class[0]);
            logger.debug("Found getter {} in class {}", (Object)getter.getName(), (Object)targetClass.getName());
            return getter;
        }
        catch (NoSuchMethodException e) {
            if (logError) {
                logger.debug("Failed to find getter for property {} in class {}", (Object)propertyName, (Object)targetClass.getName());
            }
            return null;
        }
    }

    private static String getterName(String propertyName, boolean isBooleanProperty) {
        String prefix = isBooleanProperty ? "is" : "get";
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

