/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public class ClipboardData {
    private static final int MAX_RECORD_LENGTH = 100000000;
    private static final POILogger LOG = POILogFactory.getLogger(ClipboardData.class);
    private int _format;
    private byte[] _value;

    public void read(LittleEndianByteArrayInputStream lei) {
        int offset = lei.getReadIndex();
        long size = lei.readInt();
        if (size < 4L) {
            String msg = "ClipboardData at offset " + offset + " size less than 4 bytes (doesn't even have format field!). Setting to format == 0 and hope for the best";
            LOG.log(5, msg);
            this._format = 0;
            this._value = new byte[0];
            return;
        }
        this._format = lei.readInt();
        this._value = IOUtils.safelyAllocate(size - 4L, 100000000);
        lei.readFully(this._value);
    }

    public byte[] getValue() {
        return this._value;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[8 + this._value.length];
        LittleEndian.putInt(result, 0, 4 + this._value.length);
        LittleEndian.putInt(result, 4, this._format);
        System.arraycopy(this._value, 0, result, 8, this._value.length);
        return result;
    }

    public void setValue(byte[] value) {
        this._value = (byte[])value.clone();
    }
}

